/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.yeastx.mzxml;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.xml.JaxbXmlParser;
import ch.systemsx.cisd.yeastx.db.AbstractDatasetLoader;
import ch.systemsx.cisd.yeastx.db.generic.DMDataSetDTO;
import ch.systemsx.cisd.yeastx.mzxml.IMzXmlDAO;
import ch.systemsx.cisd.yeastx.mzxml.dto.MzPrecursorDTO;
import ch.systemsx.cisd.yeastx.mzxml.dto.MzRunDTO;
import ch.systemsx.cisd.yeastx.mzxml.dto.MzScanDTO;
import ch.systemsx.cisd.yeastx.mzxml.dto.MzXmlDTO;
import java.io.File;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;

public class MzXml2Database
extends AbstractDatasetLoader<IMzXmlDAO> {
    public MzXml2Database(DataSource datasource) {
        super(datasource, IMzXmlDAO.class);
    }

    @Private
    MzXml2Database(DataSource dataSource, IMzXmlDAO dao) {
        super(dataSource, IMzXmlDAO.class, dao);
    }

    @Override
    public void upload(File file, DMDataSetDTO dataSet) throws SQLException {
        MzXmlDTO mzXml = (MzXmlDTO)JaxbXmlParser.parse(MzXmlDTO.class, (File)file, (boolean)false);
        this.uploadFile(mzXml, dataSet);
    }

    private void uploadFile(MzXmlDTO mzXml, DMDataSetDTO dataSet) throws SQLException {
        try {
            this.createDataSet(dataSet);
            this.uploadRun(mzXml.getRun(), dataSet);
        }
        catch (Throwable th) {
            this.rollbackAndRethrow(th);
        }
    }

    @Private
    void uploadRun(MzRunDTO run, DMDataSetDTO dataSet) {
        long runId = ((IMzXmlDAO)this.getDao()).addRun(dataSet, run.getInstrument());
        List<MzScanDTO> scans = run.getScans();
        for (MzScanDTO scan : scans) {
            this.uploadScan(runId, scan);
        }
    }

    private void uploadScan(long runId, MzScanDTO scan) {
        List<MzPrecursorDTO> precursors = scan.getPrecursors();
        MzPrecursorDTO precursor1 = new MzPrecursorDTO();
        MzPrecursorDTO precursor2 = new MzPrecursorDTO();
        if (precursors != null) {
            if (precursors.size() > 0) {
                precursor1 = precursors.get(0);
            }
            if (precursors.size() > 1) {
                precursor2 = precursors.get(1);
            }
            if (precursors.size() > 2) {
                throw UserFailureException.fromTemplate((String)"Scan number '%d' has %d precursors and at most 2 are supported by the data model", (Object[])new Object[]{scan.getNumber(), precursors.size()});
            }
        }
        ((IMzXmlDAO)this.getDao()).addScan(runId, scan, precursor1, precursor2);
    }
}

