/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.yeastx.quant;

import ch.systemsx.cisd.common.xml.JaxbXmlParser;
import ch.systemsx.cisd.yeastx.db.AbstractDatasetLoader;
import ch.systemsx.cisd.yeastx.db.generic.DMDataSetDTO;
import ch.systemsx.cisd.yeastx.quant.IQuantMSDAO;
import ch.systemsx.cisd.yeastx.quant.dto.ConcentrationCompounds;
import ch.systemsx.cisd.yeastx.quant.dto.MSConcentrationDTO;
import ch.systemsx.cisd.yeastx.quant.dto.MSQuantificationDTO;
import ch.systemsx.cisd.yeastx.quant.dto.MSQuantificationsDTO;
import java.io.File;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;

public class QuantML2Database
extends AbstractDatasetLoader<IQuantMSDAO> {
    public QuantML2Database(DataSource datasource) {
        super(datasource, IQuantMSDAO.class);
    }

    @Override
    public void upload(File file, DMDataSetDTO dataSet) throws SQLException {
        try {
            this.createDataSet(dataSet);
            MSQuantificationsDTO quantifications = (MSQuantificationsDTO)JaxbXmlParser.parse(MSQuantificationsDTO.class, (File)file, (boolean)false);
            this.uploadQuantifications(quantifications, dataSet);
        }
        catch (Throwable th) {
            this.rollbackAndRethrow(th);
        }
    }

    private void uploadQuantifications(MSQuantificationsDTO quantifications, DMDataSetDTO dataSet) {
        for (MSQuantificationDTO quantification : quantifications.getQuantifications()) {
            long quantificationId = ((IQuantMSDAO)this.getDao()).addQuantification(dataSet.getExperimentId(), dataSet.getId(), quantification);
            this.uploadConcentrations(quantificationId, quantification.getConcentrations());
        }
    }

    private void uploadConcentrations(long quantificationId, List<MSConcentrationDTO> concentrations) {
        for (MSConcentrationDTO concentration : concentrations) {
            long concentrationId = ((IQuantMSDAO)this.getDao()).addConcentration(quantificationId, concentration);
            this.uploadCompoundIds(concentrationId, concentration.getCompounds());
        }
    }

    private void uploadCompoundIds(long concentrationId, ConcentrationCompounds compounds) {
        ((IQuantMSDAO)this.getDao()).addCompoundIds(concentrationId, compounds.getCompoundIds());
    }
}

