/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.yeastx.utils;

import ch.systemsx.cisd.base.convert.NativeData;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import java.util.Date;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;

public class XmlUtils {
    private static final Date EPOCH = new Date(0L);
    private static DatatypeFactory DATATYPE_FACTORY = XmlUtils.createDatatypeFactory();

    public static Double tryAsSeconds(String durationText) {
        if (durationText == null) {
            return null;
        }
        Duration duration = DATATYPE_FACTORY.newDuration(durationText);
        if (duration.getMonths() != 0 || duration.getYears() != 0) {
            throw new IllegalStateException("Cannot express a duration '" + durationText + "' in a number of seconds, because it refers to months or years");
        }
        return (double)duration.getTimeInMillis(EPOCH) / 1000.0;
    }

    private static DatatypeFactory createDatatypeFactory() {
        try {
            return DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException ex) {
            throw new EnvironmentFailureException("Cannot create DatatypeFactory instance: " + ex.getMessage(), (Throwable)ex);
        }
    }

    public static float[] asFloats(byte[] bytes) {
        return NativeData.byteToFloat((byte[])bytes, (NativeData.ByteOrder)NativeData.ByteOrder.BIG_ENDIAN);
    }
}

