/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cina.client.util.cli;

import ch.systemsx.cisd.cina.client.util.cli.AbstractCinaCommand;
import ch.systemsx.cisd.cina.client.util.cli.AbstractExecutor;
import ch.systemsx.cisd.cina.client.util.v1.ICinaUtilities;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.dss.client.api.cli.GlobalArguments;
import ch.systemsx.cisd.openbis.dss.client.api.cli.ResultCode;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Experiment;
import java.util.List;
import java.util.Map;

public class CommandExperimentLister
extends AbstractCinaCommand<CommandExperimentListerArguments> {
    public CommandExperimentLister() {
        super(new CommandExperimentListerArguments());
    }

    @Override
    public ResultCode execute(String[] args) throws UserFailureException, EnvironmentFailureException {
        return new ExperimentListerExecutor(this).execute(args);
    }

    @Override
    public String getName() {
        return "listexps";
    }

    @Override
    protected String getRequiredArgumentsString() {
        return "<experiment type>";
    }

    static class CommandExperimentListerArguments
    extends GlobalArguments {
        CommandExperimentListerArguments() {
        }

        public String getExperimentTypeCode() {
            return this.getArguments().get(0).toString().toUpperCase();
        }

        @Override
        public boolean allAdditionalMandatoryArgumentsPresent() {
            if (this.getArguments().size() < 1) {
                return false;
            }
            return this.getExperimentTypeCode().length() >= 1;
        }
    }

    private static class ExperimentListerExecutor
    extends AbstractExecutor<CommandExperimentListerArguments> {
        private static final String FIELD_SEPARATOR = "\t";

        ExperimentListerExecutor(CommandExperimentLister command) {
            super(command);
        }

        @Override
        protected ResultCode doExecute(ICinaUtilities component) {
            List<Experiment> results = component.listVisibleExperiments(((CommandExperimentListerArguments)this.arguments).getExperimentTypeCode());
            this.printHeader();
            this.printResults(results);
            return ResultCode.OK;
        }

        private void printHeader() {
            StringBuilder sb = new StringBuilder();
            sb.append("EXPERIMENT");
            sb.append(FIELD_SEPARATOR);
            sb.append("TYPE");
            sb.append(FIELD_SEPARATOR);
            sb.append("DESCRIPTION");
            System.out.println(sb.toString());
        }

        private void printResults(List<Experiment> results) {
            for (Experiment experiment : results) {
                StringBuilder sb = new StringBuilder();
                sb.append(experiment.getIdentifier());
                sb.append(FIELD_SEPARATOR);
                sb.append(experiment.getExperimentTypeCode());
                sb.append(FIELD_SEPARATOR);
                Map<String, String> properties = experiment.getProperties();
                String propValue = properties.get("DESCRIPTION");
                if (propValue != null) {
                    sb.append(propValue);
                }
                System.out.println(sb.toString());
            }
        }
    }
}

