/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.client.api.gui.model;

import ch.systemsx.cisd.openbis.dss.client.api.v1.DataSet;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.NewDataSetDTO;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Sample;

public class Identifier {
    private final String fullIdentifier;
    private final String permId;
    private final NewDataSetDTO.DataSetOwnerType ownerType;

    public static Identifier create(Experiment experiment) {
        return new Identifier(experiment.getIdentifier(), experiment.getPermId(), NewDataSetDTO.DataSetOwnerType.EXPERIMENT);
    }

    public static Identifier create(Sample sample) {
        return new Identifier(sample.getIdentifier(), sample.getPermId(), NewDataSetDTO.DataSetOwnerType.SAMPLE);
    }

    public static Identifier create(DataSet dataSet) {
        return new Identifier(dataSet.getCode(), dataSet.getCode(), NewDataSetDTO.DataSetOwnerType.DATA_SET);
    }

    private Identifier(String fullIdentifier, String permId, NewDataSetDTO.DataSetOwnerType entityKind) {
        this.fullIdentifier = fullIdentifier;
        this.permId = permId;
        this.ownerType = entityKind;
    }

    public String getFullIdentifier() {
        return this.fullIdentifier;
    }

    public String getPermId() {
        return this.permId;
    }

    public NewDataSetDTO.DataSetOwnerType getOwnerType() {
        return this.ownerType;
    }

    public String toString() {
        return this.fullIdentifier;
    }
}

