/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.collection;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;

public class GroupingDAG<T> {
    private final Map<T, Integer> dependenciesCount;
    private final Map<T, Collection<T>> graph;
    private final PriorityQueue<PriorityItem> queue;
    private final List<List<T>> sortedGroups;

    private GroupingDAG(Map<T, Collection<T>> graph) {
        this.graph = graph;
        this.dependenciesCount = new HashMap<T, Integer>();
        this.queue = new PriorityQueue();
        this.sortedGroups = new LinkedList<List<T>>();
        this.initialize();
        this.sort();
    }

    public static <T> List<List<T>> groupByDepencies(Map<T, Collection<T>> graph) {
        if (graph.size() == 0) {
            return Collections.emptyList();
        }
        GroupingDAG<T> dag = new GroupingDAG<T>(graph);
        return dag.sortedGroups;
    }

    private void addNoDependency(T item) {
        if (!this.dependenciesCount.containsKey(item)) {
            this.dependenciesCount.put(item, 0);
        }
    }

    private void addDependency(T dependant) {
        int count = 0;
        if (this.dependenciesCount.containsKey(dependant)) {
            count = this.dependenciesCount.get(dependant);
        }
        this.dependenciesCount.put(dependant, count + 1);
    }

    private void initialize() {
        for (Map.Entry<T, Collection<T>> entry : this.graph.entrySet()) {
            this.addNoDependency(entry.getKey());
            for (T dependant : entry.getValue()) {
                this.addDependency(dependant);
            }
        }
        for (Object item : this.graph.keySet()) {
            this.queue.add(new PriorityItem(item));
        }
    }

    /*
     * Unable to fully structure code
     */
    private void sort() {
        while (!this.queue.isEmpty()) {
            levelItems = new LinkedList<T>();
            while (!this.queue.isEmpty() && this.peekCount() < 0) {
                this.queue.poll();
            }
            if (this.peekCount() <= 0) ** GOTO lbl17
            cycleRoot = this.queue.peek().item;
            cycle = this.graph.get(this.queue.peek().item);
            throw new UserFailureException(cycleRoot + " depends on itself. Dependency chain : " + cycleRoot + " -> " + cycle);
lbl-1000:
            // 1 sources

            {
                item = this.queue.poll().item;
                if (this.dependenciesCount.get(item) != 0) continue;
                levelItems.add(item);
                this.dependenciesCount.put(item, -1);
lbl17:
                // 3 sources

                ** while (!this.queue.isEmpty() && this.peekCount().intValue() <= 0)
            }
lbl18:
            // 1 sources

            this.sortedGroups.add(levelItems);
            if (this.queue.isEmpty()) continue;
            this.updateQueueAfterTheLevelCompleted(levelItems);
        }
    }

    private Integer peekCount() {
        return this.dependenciesCount.get(this.queue.peek().item);
    }

    private void updateQueueAfterTheLevelCompleted(List<T> levelItems) {
        HashSet<T> allSonsInTheLevel = new HashSet<T>();
        for (T item : levelItems) {
            for (T son : this.graph.get(item)) {
                allSonsInTheLevel.add(son);
                this.dependenciesCount.put(son, this.dependenciesCount.get(son) - 1);
            }
        }
        for (Object son : allSonsInTheLevel) {
            this.queue.add(new PriorityItem(son));
        }
    }

    private class PriorityItem
    implements Comparable<PriorityItem> {
        final T item;
        final Integer priority;

        public PriorityItem(T item) {
            this.item = item;
            this.priority = (Integer)GroupingDAG.this.dependenciesCount.get(item);
        }

        @Override
        public int compareTo(PriorityItem o) {
            return this.priority.compareTo(o.priority);
        }

        public String toString() {
            return "<" + this.item + ", " + this.priority + ">";
        }
    }
}

