/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.coreplugin;

import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class ModuleEnabledChecker {
    private final List<Pattern> enabledModulesPatterns = new ArrayList<Pattern>();

    public ModuleEnabledChecker(Properties properties, String key) {
        this(PropertyUtils.getList(properties, key));
    }

    public ModuleEnabledChecker(List<String> moduleRegExs) {
        for (String regex : moduleRegExs) {
            try {
                this.enabledModulesPatterns.add(Pattern.compile(regex));
            }
            catch (PatternSyntaxException ex) {
                throw new ConfigurationFailureException("Invalid regular expression: " + ex.getMessage());
            }
        }
    }

    public boolean isModuleEnabled(String module) {
        for (Pattern pattern : this.enabledModulesPatterns) {
            if (!pattern.matcher(module).matches()) continue;
            return true;
        }
        return false;
    }
}

