/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.parser;

import ch.systemsx.cisd.openbis.generic.shared.parser.GlobalProperties;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang.StringUtils;

public class GlobalPropertiesLoader {
    private static final String PREFIX = "#!";
    private static String GLOBAL_PROPERTIES_START = "GLOBAL_PROPERTIES_START";
    private static String GLOBAL_PROPERTIES_END = "GLOBAL_PROPERTIES_END";

    public static GlobalProperties load(File file) throws FileNotFoundException {
        GlobalProperties properties = new GlobalProperties();
        FileReader reader = new FileReader(file);
        try {
            LineIterator it = IOUtils.lineIterator((Reader)reader);
            boolean propertiesStarted = false;
            while (it.hasNext()) {
                String line = it.nextLine();
                if (GlobalPropertiesLoader.isGlobalPropertiesStarter(line)) {
                    propertiesStarted = true;
                    continue;
                }
                if (!propertiesStarted) continue;
                String[] definitionOrNull = GlobalPropertiesLoader.tryGetPropertyDefinition(line);
                if (definitionOrNull != null) {
                    properties.add(definitionOrNull[0], definitionOrNull[1]);
                    continue;
                }
                if (GlobalPropertiesLoader.isGlobalPropertiesStopper(line)) {
                    GlobalProperties globalProperties = properties;
                    return globalProperties;
                }
                throw new IllegalArgumentException("Illegal global property line '" + line.trim() + "'");
            }
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
        return properties;
    }

    private static String[] tryGetPropertyDefinition(String line) {
        String[] splitted;
        String commentPrefix = PREFIX;
        if (line.startsWith(commentPrefix) && (splitted = StringUtils.split((String)line.substring(commentPrefix.length()), (String)"=", (int)2)).length == 2) {
            String[] result = new String[]{StringUtils.trim((String)splitted[0]), StringUtils.trim((String)splitted[1])};
            return result;
        }
        return null;
    }

    private static boolean isGlobalPropertiesStarter(String line) {
        return line.substring(PREFIX.length()).trim().equals(GLOBAL_PROPERTIES_START);
    }

    private static boolean isGlobalPropertiesStopper(String line) {
        return line.substring(PREFIX.length()).trim().equals(GLOBAL_PROPERTIES_END);
    }
}

