/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.translator;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Code;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataStoreServiceKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatastoreServiceDescription;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ReportingPluginType;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataStoreServicePE;

public class DataStoreServiceTranslator {
    public static DatastoreServiceDescription translate(DataStoreServicePE service) {
        String[] datasetTypeCodes = Code.extractCodesToArray(service.getDatasetTypes());
        String dssCode = service.getDataStore().getCode();
        ReportingPluginType reportingPluginTypeOrNull = service.getReportingPluginTypeOrNull();
        DatastoreServiceDescription dssDescription = null;
        dssDescription = service.getKind() == DataStoreServiceKind.PROCESSING ? DatastoreServiceDescription.processing(service.getKey(), service.getLabel(), datasetTypeCodes, dssCode) : DatastoreServiceDescription.reporting(service.getKey(), service.getLabel(), datasetTypeCodes, dssCode, reportingPluginTypeOrNull);
        dssDescription.setDownloadURL(service.getDataStore().getDownloadUrl());
        return dssDescription;
    }

    private DataStoreServiceTranslator() {
    }
}

