/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.installer.izpack;

import ch.systemsx.cisd.openbis.installer.izpack.AbstractScriptExecutor;
import ch.systemsx.cisd.openbis.installer.izpack.GlobalInstallationContext;
import ch.systemsx.cisd.openbis.installer.izpack.Utils;
import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.api.data.PanelActionConfiguration;
import java.util.HashMap;

public class ExecuteBackupAction
extends AbstractScriptExecutor {
    private static final String CREATE_BACKUP_SCRIPT = "backup-installation.sh";

    @Override
    public synchronized void executeAction(AutomatedInstallData data) {
        String script = this.getAdminScript(data, CREATE_BACKUP_SCRIPT);
        String backupFolder = data.getVariable("BACKUP_FOLDER");
        String dataBasesToBackup = data.getVariable("DATABASES_TO_BACKUP");
        String console = data.getVariable("SYSTEM_CONSOLE");
        String password = Utils.tryToGetServicePropertyOfAS(GlobalInstallationContext.installDir, "database.owner-password");
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("PGPASSWORD", password);
        if (dataBasesToBackup == null) {
            if (console == null) {
                this.executeAdminScript(env, script, backupFolder);
            } else {
                this.executeAdminScript(env, script, backupFolder, "", console);
            }
        } else if (console == null) {
            this.executeAdminScript(env, script, backupFolder, dataBasesToBackup);
        } else {
            this.executeAdminScript(env, script, backupFolder, dataBasesToBackup, console);
        }
    }

    @Override
    public void initialize(PanelActionConfiguration arg0) {
    }
}

