/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.installer.izpack;

import ch.systemsx.cisd.common.shared.basic.string.CommaSeparatedListBuilder;
import ch.systemsx.cisd.openbis.installer.izpack.AbstractScriptExecutor;
import ch.systemsx.cisd.openbis.installer.izpack.GlobalInstallationContext;
import ch.systemsx.cisd.openbis.installer.izpack.JarClassLoader;
import ch.systemsx.cisd.openbis.installer.izpack.Utils;
import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.api.data.PanelActionConfiguration;
import com.izforge.izpack.data.PanelAction;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.io.output.ByteArrayOutputStream;

public class SetDatabasesToBackupAction
extends AbstractScriptExecutor
implements PanelAction {
    private static final String HELPER_CLASS = "ch.systemsx.cisd.openbis.dss.generic.server.dbbackup.BackupDatabaseDescriptionGenerator";
    static final String DATABASES_TO_BACKUP_VARNAME = "DATABASES_TO_BACKUP";

    @Override
    public void initialize(PanelActionConfiguration configuration) {
    }

    @Override
    public void executeAction(AutomatedInstallData data) {
        try {
            String descriptions = this.extractDescriptions().trim();
            String databases = this.extractDatabases(data, descriptions);
            data.setVariable(DATABASES_TO_BACKUP_VARNAME, databases);
        }
        catch (Exception ex) {
            throw new RuntimeException("Databse description extraction failed.", ex);
        }
    }

    private String extractDatabases(AutomatedInstallData data, String descriptions) {
        CommaSeparatedListBuilder builder = new CommaSeparatedListBuilder();
        if (descriptions.length() > 0) {
            String[] stringArray = descriptions.split("\n");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String description = stringArray[n2];
                DatabaseDescription databaseDescription = new DatabaseDescription(description);
                if (this.databaseExists(data, databaseDescription)) {
                    builder.append(databaseDescription.getDatabase());
                }
                ++n2;
            }
        }
        return builder.toString();
    }

    private boolean databaseExists(AutomatedInstallData data, DatabaseDescription databaseDescription) {
        File scriptFile = this.getAdminScriptFile(data, "database-existence-check.sh");
        if (!scriptFile.exists()) {
            return true;
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("PGPASSWORD", databaseDescription.getPassword());
        String database = databaseDescription.getDatabase();
        String owner = databaseDescription.getUsername();
        String host = databaseDescription.getHost();
        String port = databaseDescription.getPort();
        this.executeAdminScript(env, outputStream, outputStream, scriptFile.getAbsolutePath(), database, owner, host, port);
        return !outputStream.toString().trim().equals("FALSE");
    }

    private String extractDescriptions() throws Exception {
        Object[] arguments = this.createArguments();
        File dssLibFolder = new File(GlobalInstallationContext.installDir, "servers/datastore_server/lib");
        Class<?> clazz = new JarClassLoader(dssLibFolder).loadClass(HELPER_CLASS);
        Method method = clazz.getMethod("getDescriptions", String[].class);
        return (String)method.invoke(null, arguments);
    }

    private Object[] createArguments() {
        ArrayList<String> paths = new ArrayList<String>();
        if (Utils.isASInstalled(GlobalInstallationContext.installDir)) {
            paths.add(new File(GlobalInstallationContext.installDir, "servers/openBIS-server/jetty/etc/service.properties").getAbsolutePath());
        }
        paths.add(new File(GlobalInstallationContext.installDir, "servers/datastore_server/etc/service.properties").getAbsolutePath());
        System.out.println("Scan following properties file for data source definitions: " + paths);
        return new Object[]{paths.toArray(new String[0])};
    }

    private static final class DatabaseDescription {
        private final String description;
        private final String database;
        private final String username;
        private final String password;
        private final String host;

        DatabaseDescription(String description) {
            this.description = description;
            String[] parts = description.split(";");
            if (parts.length < 3) {
                throw new IllegalArgumentException("Only " + parts.length + " parts separated by ';' in database description: " + description);
            }
            this.database = this.getValue(parts[0]);
            this.username = this.getValue(parts[1]);
            this.password = this.getValue(parts[2]);
            this.host = parts.length == 4 ? this.getValue(parts[3]) : "localhost";
        }

        private String getValue(String part) {
            String[] splitted = part.split("=");
            return splitted.length == 1 ? "" : splitted[1].trim();
        }

        public String getDatabase() {
            return this.database;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public String getHost() {
            int indexOfColon = this.host.indexOf(58);
            return indexOfColon < 0 ? this.host : this.host.substring(0, indexOfColon);
        }

        public String getPort() {
            int indexOfColon = this.host.indexOf(58);
            return indexOfColon < 0 ? "5432" : this.host.substring(indexOfColon + 1);
        }

        public String toString() {
            return this.description;
        }
    }
}

