/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.container.provider;

import com.izforge.izpack.api.container.BindeableContainer;
import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.api.data.DynamicVariable;
import com.izforge.izpack.api.data.Info;
import com.izforge.izpack.api.data.LocaleDatabase;
import com.izforge.izpack.api.data.Pack;
import com.izforge.izpack.api.data.ResourceManager;
import com.izforge.izpack.api.data.Value;
import com.izforge.izpack.api.data.binding.IzpackProjectInstaller;
import com.izforge.izpack.api.data.binding.Listener;
import com.izforge.izpack.api.event.InstallerListener;
import com.izforge.izpack.api.exception.InstallerException;
import com.izforge.izpack.api.substitutor.VariableSubstitutor;
import com.izforge.izpack.merge.resolve.ClassPathCrawler;
import com.izforge.izpack.merge.resolve.PathResolver;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.OsConstraintHelper;
import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.TemporaryDirectory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.picocontainer.injectors.Provider;

public abstract class AbstractInstallDataProvider
implements Provider {
    protected static final String LANG_FILE_NAME = "CustomLangPack.xml";
    protected ResourceManager resourceManager;
    protected VariableSubstitutor variableSubstitutor;
    protected ClassPathCrawler classPathCrawler;

    protected void loadInstallData(AutomatedInstallData installdata) throws IOException, ClassNotFoundException, InstallerException {
        String hostname;
        String IPAddress;
        Properties variables = (Properties)this.readObject("vars");
        Info info = (Info)this.readObject("info");
        installdata.setVariable("APP_NAME", info.getAppName());
        if (info.getAppURL() != null) {
            installdata.setVariable("APP_URL", info.getAppURL());
        }
        installdata.setVariable("APP_VER", info.getAppVersion());
        if (info.getUninstallerCondition() != null) {
            installdata.setVariable("UNINSTALLER_CONDITION", info.getUninstallerCondition());
        }
        installdata.setInfo(info);
        String dir = this.getDir();
        String installPath = String.valueOf(dir) + info.getAppName();
        if (info.getInstallationSubPath() != null) {
            installPath = IoHelper.translatePath(String.valueOf(dir) + info.getInstallationSubPath(), this.variableSubstitutor);
        }
        installdata.setDefaultInstallPath(installPath);
        installPath = System.getProperty("INSTALL_PATH");
        if (installPath != null) {
            installdata.setInstallPath(installPath);
        }
        List panelsOrder = (List)this.readObject("panelsOrder");
        InputStream in = this.resourceManager.getInputStream("packs.info");
        ObjectInputStream objIn = new ObjectInputStream(in);
        int size = objIn.readInt();
        ArrayList<Pack> availablePacks = new ArrayList<Pack>();
        ArrayList<Pack> allPacks = new ArrayList<Pack>();
        int i = 0;
        while (i < size) {
            Pack pack = (Pack)objIn.readObject();
            allPacks.add(pack);
            if (OsConstraintHelper.oneMatchesCurrentSystem(pack.osConstraints)) {
                availablePacks.add(pack);
            }
            ++i;
        }
        objIn.close();
        try {
            InetAddress addr = InetAddress.getLocalHost();
            IPAddress = addr.getHostAddress();
            hostname = addr.getHostName();
        }
        catch (Exception e) {
            hostname = "";
            IPAddress = "";
        }
        installdata.setVariable("APPLICATIONS_DEFAULT_ROOT", dir);
        dir = String.valueOf(dir) + File.separator;
        installdata.setVariable("JAVA_HOME", System.getProperty("java.home"));
        installdata.setVariable("CLASS_PATH", System.getProperty("java.class.path"));
        installdata.setVariable("USER_HOME", System.getProperty("user.home"));
        installdata.setVariable("USER_NAME", System.getProperty("user.name"));
        installdata.setVariable("IP_ADDRESS", IPAddress);
        installdata.setVariable("HOST_NAME", hostname);
        installdata.setVariable("FILE_SEPARATOR", File.separator);
        Enumeration<Object> systemProperties = System.getProperties().keys();
        while (systemProperties.hasMoreElements()) {
            String varName = (String)systemProperties.nextElement();
            String varValue = System.getProperty(varName);
            if (varValue == null) continue;
            varName = varName.replace('.', '_');
            installdata.setVariable("SYSTEM_" + varName, varValue);
        }
        if (variables != null) {
            Enumeration<Object> enumeration = variables.keys();
            while (enumeration.hasMoreElements()) {
                String varName = (String)enumeration.nextElement();
                String varValue = variables.getProperty(varName);
                installdata.setVariable(varName, varValue);
            }
        }
        installdata.setPanelsOrder(panelsOrder);
        installdata.setAvailablePacks(availablePacks);
        installdata.setAllPacks(allPacks);
        for (Pack availablePack : availablePacks) {
            if (!availablePack.preselected) continue;
            installdata.getSelectedPacks().add(availablePack);
        }
        Set<Info.TempDir> tempDirs = info.getTempDirs();
        if (tempDirs != null && tempDirs.size() > 0) {
            for (Info.TempDir tempDir : tempDirs) {
                TemporaryDirectory directory = new TemporaryDirectory(tempDir, installdata);
                directory.create();
                if (Debug.tracing()) continue;
                directory.cleanUp();
            }
        }
    }

    protected void addCustomLangpack(AutomatedInstallData idata) {
        try {
            idata.getLangpack().add(this.resourceManager.getInputStream(LANG_FILE_NAME));
        }
        catch (Throwable exception) {
            Debug.trace("No custom langpack available.");
            return;
        }
        Debug.trace("Custom langpack for " + idata.getLocaleISO3() + " available.");
    }

    protected void loadCustomData(AutomatedInstallData installdata, BindeableContainer bindeableContainer, PathResolver pathResolver) throws IOException, InstallerException, ClassNotFoundException {
        IzpackProjectInstaller izpackModel = (IzpackProjectInstaller)this.readObject("izpackInstallModel");
        ArrayList<InstallerListener> customActions = new ArrayList<InstallerListener>();
        for (Listener listener : izpackModel.getListeners()) {
            if (!OsConstraintHelper.oneMatchesCurrentSystem(listener.getOs())) continue;
            switch (listener.getStage()) {
                case install: {
                    Class aClass = this.classPathCrawler.searchClassInClassPath(listener.getClassname());
                    bindeableContainer.addComponent(aClass);
                    customActions.add((InstallerListener)bindeableContainer.getComponent(aClass));
                }
            }
        }
        installdata.setInstallerListener(customActions);
    }

    private String getDir() {
        String dir = OsVersion.IS_WINDOWS ? this.buildWindowsDefaultPath() : (OsVersion.IS_OSX ? "/Applications/" : (new File("/usr/local/").canWrite() ? "/usr/local/" : String.valueOf(System.getProperty("user.home")) + File.separatorChar));
        return dir;
    }

    private String buildWindowsDefaultPath() {
        try {
            String prgFilesPath = IoHelper.getenv("ProgramFiles");
            if (prgFilesPath != null && prgFilesPath.length() > 0) {
                return String.valueOf(prgFilesPath) + File.separatorChar;
            }
            return this.buildWindowsDefaultPathFromProps();
        }
        catch (Exception x) {
            x.printStackTrace();
            return this.buildWindowsDefaultPathFromProps();
        }
    }

    private String buildWindowsDefaultPathFromProps() {
        StringBuffer dpath = new StringBuffer("");
        try {
            Properties props = new Properties();
            props.load(this.resourceManager.getInputStream("/com/izforge/izpack/installer/win32-defaultpaths.properties"));
            String drive = System.getProperty("user.home");
            if (drive.length() > 3) {
                drive = drive.substring(0, 3);
            }
            dpath.append(drive);
            if (drive.length() == 2) {
                dpath.append("\\");
            }
            String language = Locale.getDefault().getLanguage();
            String country = Locale.getDefault().getCountry();
            String language_country = String.valueOf(language) + "_" + country;
            if (props.getProperty(language_country) != null) {
                dpath.append(props.getProperty(language_country));
            } else if (props.getProperty(language) != null) {
                dpath.append(props.getProperty(language));
            } else {
                dpath.append(props.getProperty(Locale.ENGLISH.getLanguage()));
            }
        }
        catch (Exception err) {
            dpath = new StringBuffer("C:\\Program Files");
        }
        return dpath.toString();
    }

    protected void loadDynamicVariables(AutomatedInstallData automatedInstallData) {
        try {
            InputStream in = this.resourceManager.getInputStream("dynvariables");
            ObjectInputStream objIn = new ObjectInputStream(in);
            Map dynamicvariables = (Map)objIn.readObject();
            objIn.close();
            for (List dynVarList : dynamicvariables.values()) {
                for (DynamicVariable dynVar : dynVarList) {
                    Value value = dynVar.getValue();
                    value.setInstallData(automatedInstallData);
                }
            }
            automatedInstallData.setDynamicvariables(dynamicvariables);
        }
        catch (Exception e) {
            Debug.trace("Cannot find optional dynamic variables");
            System.out.println(e);
        }
    }

    protected void loadDynamicConditions(AutomatedInstallData automatedInstallData) {
        try {
            InputStream in = this.resourceManager.getInputStream("dynconditions");
            ObjectInputStream objIn = new ObjectInputStream(in);
            automatedInstallData.setDynamicinstallerrequirements((List)objIn.readObject());
            objIn.close();
        }
        catch (Exception e) {
            Debug.trace("Cannot find optional dynamic conditions");
            System.out.println(e);
        }
    }

    public void loadInstallerRequirements(AutomatedInstallData automatedInstallData) throws Exception {
        InputStream in = this.resourceManager.getInputStream("installerrequirements");
        ObjectInputStream objIn = new ObjectInputStream(in);
        automatedInstallData.setInstallerrequirements((List)objIn.readObject());
        objIn.close();
    }

    protected void loadDefaultLocale(AutomatedInstallData automatedInstallData) throws Exception {
        List<String> availableLangPacks = this.resourceManager.getAvailableLangPacks();
        String selectedPack = availableLangPacks.get(0);
        InputStream in = this.resourceManager.getInputStream("langpacks/" + selectedPack + ".xml");
        automatedInstallData.setAndProcessLocal(selectedPack, new LocaleDatabase(in));
        this.resourceManager.setLocale(selectedPack);
    }

    public Object readObject(String resourceId) throws IOException, ClassNotFoundException {
        InputStream inputStream = this.resourceManager.getInputStream(resourceId);
        ObjectInputStream objIn = new ObjectInputStream(inputStream);
        Object model = objIn.readObject();
        objIn.close();
        return model;
    }
}

