import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.DataType as DataType

tr = service.transaction()

vocabulary_TREATMENT_TYPE = tr.getOrCreateNewVocabulary('TREATMENT_TYPE')
vocabulary_TREATMENT_TYPE.setDescription('Type of treatment of a biological sample.')
vocabulary_TREATMENT_TYPE.setUrlTemplate(None)
vocabulary_TREATMENT_TYPE.setManagedInternally(False)
vocabulary_TREATMENT_TYPE.setInternalNamespace(False)
vocabulary_TREATMENT_TYPE.setChosenFromList(True)

prop_type_NOT_PROCESSED = tr.getOrCreateNewPropertyType('NOT_PROCESSED', DataType.VARCHAR)
prop_type_NOT_PROCESSED.setLabel('Not Processed')
prop_type_NOT_PROCESSED.setDescription('Reason why prot.xml file has not been processed.')
prop_type_NOT_PROCESSED.setManagedInternally(False)
prop_type_NOT_PROCESSED.setInternalNamespace(False)

exp_type_MS_SEARCH = tr.getOrCreateNewExperimentType('MS_SEARCH')
exp_type_MS_SEARCH.setDescription('MS_SEARCH experiment')

assignment_MS_SEARCH_NOT_PROCESSED = tr.assignPropertyType(exp_type_MS_SEARCH, prop_type_NOT_PROCESSED)
assignment_MS_SEARCH_NOT_PROCESSED.setMandatory(False)
assignment_MS_SEARCH_NOT_PROCESSED.setSection(None)
assignment_MS_SEARCH_NOT_PROCESSED.setPositionInForms(1)

samp_type_MS_INJECTION = tr.getOrCreateNewSampleType('MS_INJECTION')
samp_type_MS_INJECTION.setDescription('injection of a biological sample into a MS')
samp_type_MS_INJECTION.setListable(True)
samp_type_MS_INJECTION.setSubcodeUnique(False)
samp_type_MS_INJECTION.setAutoGeneratedCode(False)
samp_type_MS_INJECTION.setGeneratedCodePrefix('S')

samp_type_SEARCH = tr.getOrCreateNewSampleType('SEARCH')
samp_type_SEARCH.setDescription('pointer to an MS_INJECTION sample used as placeholder for searches')
samp_type_SEARCH.setListable(True)
samp_type_SEARCH.setSubcodeUnique(False)
samp_type_SEARCH.setAutoGeneratedCode(False)
samp_type_SEARCH.setGeneratedCodePrefix('S')

data_set_type_PROT_RESULT = tr.getOrCreateNewDataSetType('PROT_RESULT')
data_set_type_PROT_RESULT.setDescription('protXML file')
data_set_type_PROT_RESULT.setContainerType(False)

