/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.logging;

import ch.systemsx.cisd.common.logging.ISimpleLogger;
import ch.systemsx.cisd.common.logging.LogLevel;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class Log4jSimpleLogger
implements ISimpleLogger {
    private final Priority log4jOverridePriorityOrNull;
    private final Logger log4jLogger;

    static final Level toLog4jPriority(LogLevel level) {
        switch (level) {
            case OFF: {
                return Level.OFF;
            }
            case TRACE: {
                return Level.TRACE;
            }
            case DEBUG: {
                return Level.DEBUG;
            }
            case INFO: {
                return Level.INFO;
            }
            case WARN: {
                return Level.WARN;
            }
            case ERROR: {
                return Level.ERROR;
            }
        }
        throw new IllegalArgumentException("Illegal log level " + (Object)((Object)level));
    }

    public Log4jSimpleLogger(Logger log4jLogger, Priority log4jOverridePriorityOrNull) {
        assert (log4jLogger != null) : "Unspecified log4j logger";
        this.log4jOverridePriorityOrNull = log4jOverridePriorityOrNull;
        this.log4jLogger = log4jLogger;
    }

    public Log4jSimpleLogger(Logger log4jLogger) {
        this(log4jLogger, null);
    }

    @Override
    public void log(LogLevel level, String message) {
        this.log(level, message, null);
    }

    @Override
    public void log(LogLevel level, String message, Throwable throwableOrNull) {
        if (this.log4jOverridePriorityOrNull != null) {
            this.log4jLogger.log(this.log4jOverridePriorityOrNull, message, throwableOrNull);
        } else {
            this.log4jLogger.log(Log4jSimpleLogger.toLog4jPriority(level), message, throwableOrNull);
        }
    }
}

