/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.api.v1;

import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.mail.IMailClient;
import ch.systemsx.cisd.common.mail.MailClient;
import ch.systemsx.cisd.etlserver.DataStrategyStore;
import ch.systemsx.cisd.etlserver.ITopLevelDataSetRegistrator;
import ch.systemsx.cisd.etlserver.TopLevelDataSetRegistratorGlobalState;
import ch.systemsx.cisd.etlserver.api.v1.DataSetTypeToRegistratorMapper;
import ch.systemsx.cisd.etlserver.api.v1.PutDataSetExecutor;
import ch.systemsx.cisd.etlserver.api.v1.PutDataSetServerPluginHolder;
import ch.systemsx.cisd.etlserver.api.v1.PutDataSetServiceInitializer;
import ch.systemsx.cisd.etlserver.api.v1.PutDataSetTopLevelDataSetHandler;
import ch.systemsx.cisd.etlserver.validation.IDataSetValidator;
import ch.systemsx.cisd.openbis.common.io.ByteArrayBasedContentNode;
import ch.systemsx.cisd.openbis.common.io.ConcatenatedContentInputStream;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.FileInfoDssDTO;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.NewDataSetDTO;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.validation.ValidationScriptReader;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.SegmentedStoreUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.CustomImportFile;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseInstance;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class PutDataSetService {
    private final IEncapsulatedOpenBISService openBisService;
    private final Logger operationLog;
    private final Lock registrationLock;
    private DataSetTypeToRegistratorMapper registratorMap;
    private DataStrategyStore dataStrategyStore;
    private File storeDirectory;
    private String dataStoreCode;
    private boolean isInitialized = false;
    private IMailClient mailClient;
    private IDataSetValidator dataSetValidator;
    private DatabaseInstance homeDatabaseInstance;

    public PutDataSetService(IEncapsulatedOpenBISService openBisService, Logger operationLog) {
        this.openBisService = openBisService;
        this.operationLog = operationLog;
        this.registrationLock = new ReentrantLock();
    }

    public PutDataSetService(IEncapsulatedOpenBISService openBisService, Logger operationLog, File store, DataSetTypeToRegistratorMapper map, IMailClient mail, String dsCode, IDataSetValidator validator) {
        this(openBisService, operationLog);
        this.registratorMap = map;
        this.storeDirectory = store;
        this.registratorMap.initializeStoreRootDirectory(this.storeDirectory);
        this.mailClient = mail;
        this.dataStrategyStore = new DataStrategyStore(openBisService, this.mailClient);
        this.dataStoreCode = dsCode;
        this.homeDatabaseInstance = openBisService.getHomeDatabaseInstance();
        this.dataSetValidator = validator;
        this.isInitialized = true;
    }

    public String putDataSet(String sessionToken, String dropboxName, CustomImportFile customImportFile) {
        if (!this.isInitialized) {
            this.doInitialization();
        }
        try {
            ITopLevelDataSetRegistrator registrator = this.registratorMap.getRegistratorForDropbox(dropboxName);
            List<DataSetInformation> infos = registrator instanceof PutDataSetServerPluginHolder ? new PutDataSetExecutor(this, ((PutDataSetServerPluginHolder)registrator).getPlugin(), sessionToken, this.createNewDataSetDTO(customImportFile), this.getAsInputStream(customImportFile)).execute() : new PutDataSetTopLevelDataSetHandler(this, registrator, sessionToken, this.createNewDataSetDTO(customImportFile), this.getAsInputStream(customImportFile)).execute();
            StringBuilder sb = new StringBuilder();
            for (DataSetInformation info : infos) {
                sb.append(info.getDataSetCode());
                sb.append(",");
            }
            if (sb.length() > 0) {
                sb.deleteCharAt(sb.length() - 1);
            }
            return sb.toString();
        }
        catch (UserFailureException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IOException e) {
            throw new IOExceptionUnchecked(e);
        }
    }

    private InputStream getAsInputStream(CustomImportFile customImportFile) {
        return new ConcatenatedContentInputStream(false, new ByteArrayBasedContentNode(customImportFile.getBytes(), customImportFile.getFileName()));
    }

    private NewDataSetDTO createNewDataSetDTO(CustomImportFile customImportFile) {
        return new NewDataSetDTO(null, null, Collections.singletonList(new FileInfoDssDTO(customImportFile.getFileName(), customImportFile.getFileName(), false, customImportFile.getBytes().length)));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String putDataSet(String sessionToken, NewDataSetDTO newDataSet, InputStream inputStream) throws IOExceptionUnchecked, IllegalArgumentException {
        String string;
        if (!this.isInitialized) {
            this.doInitialization();
        }
        try {
            String dataSetTypeOrNull = newDataSet.tryDataSetType();
            ITopLevelDataSetRegistrator registrator = this.registratorMap.getRegistratorForType(dataSetTypeOrNull);
            List<DataSetInformation> infos = registrator instanceof PutDataSetServerPluginHolder ? new PutDataSetExecutor(this, ((PutDataSetServerPluginHolder)registrator).getPlugin(), sessionToken, newDataSet, inputStream).execute() : new PutDataSetTopLevelDataSetHandler(this, registrator, sessionToken, newDataSet, inputStream).execute();
            StringBuilder sb = new StringBuilder();
            Iterator<DataSetInformation> iterator = infos.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    if (sb.length() > 0) {
                        sb.deleteCharAt(sb.length() - 1);
                    }
                    string = sb.toString();
                    break;
                }
                DataSetInformation info = iterator.next();
                sb.append(info.getDataSetCode());
                sb.append(",");
            }
        }
        catch (UserFailureException e) {
            try {
                throw new IllegalArgumentException(e);
                catch (IOException e2) {
                    throw new IOExceptionUnchecked(e2);
                }
            }
            catch (Throwable throwable) {
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            inputStream.close();
            return string;
        }
        catch (IOException iOException) {}
        return string;
    }

    public String getValidationScript(String dataSetTypeOrNull) {
        ITopLevelDataSetRegistrator registrator;
        TopLevelDataSetRegistratorGlobalState globalState;
        String[] scriptPaths;
        if (!this.isInitialized) {
            this.doInitialization();
        }
        if ((scriptPaths = (globalState = (registrator = this.registratorMap.getRegistratorForType(dataSetTypeOrNull)).getGlobalState()).getValidationScriptsOrNull()) == null) {
            return null;
        }
        return ValidationScriptReader.tryReadValidationScript(scriptPaths);
    }

    private void doInitialization() {
        PutDataSetServiceInitializer initializer = new PutDataSetServiceInitializer();
        this.mailClient = new MailClient(initializer.getMailProperties());
        this.dataStrategyStore = new DataStrategyStore(this.openBisService, this.mailClient);
        this.dataStoreCode = initializer.getDataStoreCode();
        this.homeDatabaseInstance = this.openBisService.getHomeDatabaseInstance();
        this.dataSetValidator = initializer.getDataSetValidator();
        File[] shares = SegmentedStoreUtils.getShares(this.storeDirectory);
        if (shares.length == 0 && !new File(this.storeDirectory, "1").mkdirs()) {
            throw new ConfigurationFailureException("Can not create default share in store: " + this.storeDirectory);
        }
        this.registratorMap = initializer.getRegistratorMap(this.openBisService, this.mailClient);
        this.registratorMap.initializeStoreRootDirectory(this.storeDirectory);
        this.isInitialized = true;
    }

    IEncapsulatedOpenBISService getOpenBisService() {
        return this.openBisService;
    }

    IMailClient getMailClient() {
        return this.mailClient;
    }

    String getShareId(String dataSetTypeOrNull) {
        return this.getThreadGlobalState(dataSetTypeOrNull).getShareId();
    }

    File getIncomingDir(String dataSetTypeOrNull) {
        return this.getThreadGlobalState(dataSetTypeOrNull).getThreadParameters().getIncomingDataDirectory();
    }

    private TopLevelDataSetRegistratorGlobalState getThreadGlobalState(String dataSetTypeOrNull) {
        return this.registratorMap.getRegistratorForType(dataSetTypeOrNull).getGlobalState();
    }

    Logger getOperationLog() {
        return this.operationLog;
    }

    Lock getRegistrationLock() {
        return this.registrationLock;
    }

    DataStrategyStore getDataStrategyStore() {
        return this.dataStrategyStore;
    }

    String getDataStoreCode() {
        return this.dataStoreCode;
    }

    IDataSetValidator getDataSetValidator() {
        return this.dataSetValidator;
    }

    DatabaseInstance getHomeDatabaseInstance() {
        return this.homeDatabaseInstance;
    }

    public File getStoreRootDirectory() {
        return this.storeDirectory;
    }

    public void setStoreDirectory(File storeDirectory) {
        this.storeDirectory = storeDirectory;
    }

    public File createTemporaryIncomingDir(String dataSetTypeCodeOrNull) {
        String uniqueFolderName = this.openBisService.createPermId();
        File temporaryIncomingDir = new File(this.getTemporaryIncomingRoot(dataSetTypeCodeOrNull), uniqueFolderName);
        temporaryIncomingDir.mkdir();
        return temporaryIncomingDir;
    }

    private File getTemporaryIncomingRoot(String dataSetTypeCodeOrNull) {
        File shareRoot;
        TopLevelDataSetRegistratorGlobalState globalState = this.getThreadGlobalState(dataSetTypeCodeOrNull);
        File storeRoot = globalState.getStoreRootDir();
        if (!StringUtils.isBlank((String)globalState.getShareId()) && (shareRoot = new File(storeRoot, globalState.getShareId())).isDirectory()) {
            File incomingDir = new File(shareRoot, "rpc-incoming");
            incomingDir.mkdir();
            if (incomingDir.isDirectory()) {
                return incomingDir;
            }
        }
        return storeRoot;
    }
}

