/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.registrator.v2;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.base.exceptions.InterruptedExceptionUnchecked;
import ch.systemsx.cisd.common.concurrent.ConcurrencyUtilities;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.etlserver.DssRegistrationLogger;
import ch.systemsx.cisd.etlserver.IStorageProcessorTransactional;
import ch.systemsx.cisd.etlserver.TopLevelDataSetRegistratorGlobalState;
import ch.systemsx.cisd.etlserver.registrator.DataSetFile;
import ch.systemsx.cisd.etlserver.registrator.DataSetRegistrationContext;
import ch.systemsx.cisd.etlserver.registrator.DistinctExceptionsCollection;
import ch.systemsx.cisd.etlserver.registrator.IRollbackStack;
import ch.systemsx.cisd.etlserver.registrator.ITransactionalCommand;
import ch.systemsx.cisd.etlserver.registrator.IncomingFileDeletedBeforeRegistrationException;
import ch.systemsx.cisd.etlserver.registrator.api.v2.impl.DataSetRegistrationTransaction;
import ch.systemsx.cisd.etlserver.registrator.monitor.DssRegistrationHealthMonitor;
import ch.systemsx.cisd.etlserver.registrator.recovery.IDataSetStorageRecoveryManager;
import ch.systemsx.cisd.etlserver.registrator.v2.DataSetStorageAlgorithm;
import ch.systemsx.cisd.etlserver.registrator.v2.IDataSetOnErrorActionDecision;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetRegistrationInformation;
import ch.systemsx.cisd.openbis.generic.shared.basic.EntityOperationsState;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.dto.AtomicEntityOperationResult;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.log4j.Logger;

public class DataSetStorageAlgorithmRunner<T extends DataSetInformation> {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, DataSetStorageAlgorithmRunner.class);
    public static final String DATA_SET_REGISTRATION_FAILURE_TEMPLATE = "Registration of data set '%s' failed.";
    public static final String DATA_SET_STORAGE_FAILURE_TEMPLATE = "Storing data set '%s' failed.";
    public static final String SUCCESSFULLY_REGISTERED = "Successfully registered data set: [";
    private final ArrayList<DataSetStorageAlgorithm<T>> dataSetStorageAlgorithms;
    private final IDataSetInApplicationServerRegistrator<T> applicationServerRegistrator;
    private final IRollbackDelegate<T> rollbackDelegate;
    private final IRollbackStack rollbackStack;
    private final DataSetRegistrationContext.IHolder registrationContextHolder;
    private final IPrePostRegistrationHook<T> postPreRegistrationHooks;
    private final DssRegistrationLogger dssRegistrationLog;
    private final IEncapsulatedOpenBISService openBISService;
    private final IDataSetStorageRecoveryManager storageRecoveryManager;
    private final DataSetFile incomingDataSetFile;
    private final int registrationMaxRetryCount;
    private final int registrationRetryPauseInSec;

    public DataSetStorageAlgorithmRunner(List<DataSetStorageAlgorithm<T>> dataSetStorageAlgorithms, DataSetRegistrationTransaction<T> transaction, IRollbackStack rollbackStack, DssRegistrationLogger dssRegistrationLog, IEncapsulatedOpenBISService openBISService, IPrePostRegistrationHook<T> postPreRegistrationHooks, TopLevelDataSetRegistratorGlobalState globalState) {
        this.dataSetStorageAlgorithms = new ArrayList<DataSetStorageAlgorithm<T>>(dataSetStorageAlgorithms);
        this.rollbackDelegate = transaction;
        this.applicationServerRegistrator = transaction;
        this.registrationContextHolder = transaction;
        this.rollbackStack = rollbackStack;
        this.dssRegistrationLog = dssRegistrationLog;
        this.openBISService = openBISService;
        this.postPreRegistrationHooks = postPreRegistrationHooks;
        this.storageRecoveryManager = transaction.getStorageRecoveryManager();
        this.incomingDataSetFile = transaction.getIncomingDataSetFile();
        this.registrationMaxRetryCount = globalState.getThreadParameters().getDataSetRegistrationMaxRetryCount();
        this.registrationRetryPauseInSec = globalState.getThreadParameters().getDataSetRegistrationPauseInSec();
    }

    public DataSetStorageAlgorithmRunner(DataSetFile incomingDataSetFile, List<DataSetStorageAlgorithm<T>> dataSetStorageAlgorithms, IRollbackDelegate<T> rollbackDelegate, IRollbackStack rollbackStack, DssRegistrationLogger dssRegistrationLog, IEncapsulatedOpenBISService openBISService, IPrePostRegistrationHook<T> postPreRegistrationHooks, IDataSetStorageRecoveryManager storageRecoveryManager, DataSetRegistrationContext.IHolder registrationContextHolder, TopLevelDataSetRegistratorGlobalState globalState) {
        this.dataSetStorageAlgorithms = new ArrayList<DataSetStorageAlgorithm<T>>(dataSetStorageAlgorithms);
        this.rollbackDelegate = rollbackDelegate;
        this.applicationServerRegistrator = null;
        this.registrationContextHolder = registrationContextHolder;
        this.rollbackStack = rollbackStack;
        this.dssRegistrationLog = dssRegistrationLog;
        this.openBISService = openBISService;
        this.postPreRegistrationHooks = postPreRegistrationHooks;
        this.storageRecoveryManager = storageRecoveryManager;
        this.incomingDataSetFile = incomingDataSetFile;
        this.registrationMaxRetryCount = globalState.getThreadParameters().getDataSetRegistrationMaxRetryCount();
        this.registrationRetryPauseInSec = globalState.getThreadParameters().getDataSetRegistrationPauseInSec();
    }

    public final boolean safePrepare() {
        try {
            this.prepare();
        }
        catch (Throwable throwable) {
            this.rollbackDuringPreparation(throwable);
            return false;
        }
        this.dssRegistrationLog.info(operationLog, "Preparation ready");
        return true;
    }

    private final void prepare() {
        StringBuilder registrationSummary = new StringBuilder();
        registrationSummary.append("Prepared registration of ");
        registrationSummary.append(this.dataSetStorageAlgorithms.size());
        if (1 == this.dataSetStorageAlgorithms.size()) {
            registrationSummary.append(" data set:");
        } else {
            registrationSummary.append(" data sets:");
        }
        registrationSummary.append("\n\t");
        for (DataSetStorageAlgorithm<T> storageAlgorithm : this.dataSetStorageAlgorithms) {
            IStorageProcessorTransactional.IStorageProcessorTransaction transaction1 = storageAlgorithm.prepare(this.rollbackStack);
            StorageProcessorTransactionCommand command = new StorageProcessorTransactionCommand(transaction1);
            this.rollbackStack.pushAndExecuteCommand(command);
            registrationSummary.append(((DataSetInformation)storageAlgorithm.getDataSetInformation()).getDataSetCode());
            registrationSummary.append(",");
        }
        registrationSummary.deleteCharAt(registrationSummary.length() - 1);
        this.dssRegistrationLog.logTruncatingIfNecessary(registrationSummary.toString());
    }

    private boolean confirmStorageInApplicationServer() {
        try {
            for (DataSetStorageAlgorithm<T> storageAlgorithm : this.dataSetStorageAlgorithms) {
                String dataSetCode = ((DataSetInformation)storageAlgorithm.getDataSetInformation()).getDataSetCode();
                this.openBISService.setStorageConfirmed(dataSetCode);
            }
            this.dssRegistrationLog.info(operationLog, "Storage has been confirmed in openBIS Application Server.");
        }
        catch (Exception ex) {
            this.rollbackDelegate.markReadyForRecovery(this, ex);
            this.dssRegistrationLog.error(operationLog, "Error during storage confirmation", ex);
            return false;
        }
        return true;
    }

    private void logPreCommitMessage() {
        if (this.dataSetStorageAlgorithms.size() > 0) {
            DataSetStorageAlgorithm<T> anAlgorithm = this.dataSetStorageAlgorithms.get(0);
            File precommitDirectory = anAlgorithm.getPreCommitDirectory();
            this.dssRegistrationLog.info(operationLog, "Data has been moved to the pre-commit directory: " + precommitDirectory.getAbsolutePath());
        } else {
            this.dssRegistrationLog.info(operationLog, "In pre-commit state; no data needed to be moved.");
        }
    }

    private boolean executePreRegistrationHooks() {
        try {
            this.postPreRegistrationHooks.executePreRegistration(this.registrationContextHolder);
        }
        catch (Throwable throwable) {
            this.dssRegistrationLog.error(operationLog, "Error in execution of pre registration hooks", throwable);
            this.rollbackDuringPreRegistration(throwable);
            return false;
        }
        return true;
    }

    public boolean prepareAndRunStorageAlgorithms() {
        if (!this.safePrepare()) {
            return false;
        }
        if (!this.preCommitStorageAlgorithms()) {
            return false;
        }
        if (!this.executePreRegistrationHooks()) {
            return false;
        }
        ArrayList<DataSetRegistrationInformation<T>> registrationData = this.tryPrepareRegistrationData();
        TechId registrationId = new TechId(this.openBISService.drawANewUniqueID());
        this.logMetadataRegistration(registrationId);
        if (registrationData == null) {
            return false;
        }
        this.storageRecoveryManager.checkpointPrecommittedState(registrationId, this);
        this.waitUntilApplicationIsReady();
        if (!this.registerDataSetsInApplicationServer(registrationId, registrationData)) {
            return false;
        }
        this.postRegistration();
        if (!this.commitAndStore()) {
            return false;
        }
        return this.cleanPrecommitAndConfirmStorage();
    }

    public void postRegistration() {
        this.executeJythonScriptsForPostRegistration();
        this.storageRecoveryManager.checkpointPrecommittedStateAfterPostRegistrationHook(this);
        this.waitUntilApplicationIsReady();
    }

    private void logMetadataRegistration(TechId registrationId) {
        this.dssRegistrationLog.info(operationLog, "About to register metadata with AS: registrationId(" + registrationId.toString() + ")");
    }

    public boolean commitAndStore() {
        if (!this.commitStorageProcessors()) {
            return false;
        }
        if (!this.storeCommitedDatasets()) {
            return false;
        }
        this.storageRecoveryManager.checkpointStoredStateBeforeStorageConfirmation(this);
        this.waitUntilApplicationIsReady();
        return true;
    }

    private void waitUntilApplicationIsReady() {
        DssRegistrationHealthMonitor.DssRegistrationHealthState healthState;
        while ((healthState = DssRegistrationHealthMonitor.getInstance().checkHealthState(this.incomingDataSetFile.getRealIncomingFile().getParentFile())).isUnavailable()) {
            this.dssRegistrationLog.info(operationLog, "Cannot process unless filesystems and application server are available. Reason: " + (Object)((Object)healthState));
            this.waitTheRetryPeriod();
        }
    }

    public boolean cleanPrecommitAndConfirmStorage() {
        this.cleanPrecommitDirectory();
        boolean confirmStorageSucceeded = this.confirmStorageInApplicationServer();
        if (!confirmStorageSucceeded) {
            return false;
        }
        this.storageRecoveryManager.registrationCompleted(this);
        return true;
    }

    private ArrayList<DataSetRegistrationInformation<T>> tryPrepareRegistrationData() {
        try {
            ArrayList<DataSetRegistrationInformation<T>> registrationData = new ArrayList<DataSetRegistrationInformation<T>>();
            for (DataSetStorageAlgorithm<T> storageAlgorithm : this.dataSetStorageAlgorithms) {
                registrationData.add(new DataSetRegistrationInformation<T>(storageAlgorithm.getDataSetInformation(), storageAlgorithm.createExternalData()));
            }
            return registrationData;
        }
        catch (Throwable t) {
            this.rollbackDuringMetadataRegistration(t);
            return null;
        }
    }

    private void rollbackDuringStorageProcessorRun(Throwable ex) {
        operationLog.error("Failed to run storage processor");
        this.rollbackStorageProcessors(ex);
        this.rollbackDelegate.didRollbackStorageAlgorithmRunner(this, ex, IDataSetOnErrorActionDecision.ErrorType.STORAGE_PROCESSOR_ERROR);
    }

    private void rollbackDuringPreparation(Throwable ex) {
        operationLog.error("Failed to prepare");
        this.rollbackStorageProcessors(ex);
        this.rollbackDelegate.didRollbackStorageAlgorithmRunner(this, ex, IDataSetOnErrorActionDecision.ErrorType.PREPARATION_ERROR);
    }

    private void rollbackDuringPreRegistration(Throwable ex) {
        operationLog.error("Failed to pre-register", ex);
        this.rollbackStorageProcessors(ex);
        this.rollbackDelegate.didRollbackStorageAlgorithmRunner(this, ex, IDataSetOnErrorActionDecision.ErrorType.PRE_REGISTRATION_ERROR);
    }

    private void rollbackDuringMetadataRegistration(Throwable ex) {
        if (!(ex instanceof IncomingFileDeletedBeforeRegistrationException)) {
            operationLog.error("Failed to register metadata", ex);
        }
        this.rollbackStorageProcessors(ex);
        this.rollbackDelegate.didRollbackStorageAlgorithmRunner(this, ex, IDataSetOnErrorActionDecision.ErrorType.OPENBIS_REGISTRATION_FAILURE);
    }

    private boolean storeCommitedDatasets() {
        try {
            for (DataSetStorageAlgorithm<T> storageAlgorithm : this.dataSetStorageAlgorithms) {
                storageAlgorithm.moveToTheStore();
            }
            this.logSuccessfulRegistration();
            this.dssRegistrationLog.info(operationLog, "Data has been moved to the final store.");
        }
        catch (Throwable throwable) {
            this.rollbackDelegate.markReadyForRecovery(this, throwable);
            this.dssRegistrationLog.error(operationLog, "Error while storing committed datasets", throwable);
            return false;
        }
        return true;
    }

    private void cleanPrecommitDirectory() {
        try {
            for (DataSetStorageAlgorithm<T> storageAlgorithm : this.dataSetStorageAlgorithms) {
                storageAlgorithm.cleanPrecommitDirectory();
            }
        }
        catch (Throwable throwable) {
            operationLog.warn("Failed to delete precommit directory", throwable);
        }
    }

    private boolean commitStorageProcessors() {
        try {
            for (DataSetStorageAlgorithm<T> storageAlgorithm : this.dataSetStorageAlgorithms) {
                storageAlgorithm.commitStorageProcessor();
            }
            this.dssRegistrationLog.info(operationLog, "Storage processors have committed.");
        }
        catch (Throwable throwable) {
            this.dssRegistrationLog.error(operationLog, "Error while committing storage processors", throwable);
            this.rollbackDelegate.markReadyForRecovery(this, throwable);
            return false;
        }
        return true;
    }

    private boolean registerDataSetsInApplicationServer(TechId registrationId, List<DataSetRegistrationInformation<T>> registrationData) {
        this.dssRegistrationLog.info(operationLog, "Will try to register data in openbis.");
        boolean result = this.registerDataWithRecovery(registrationId, registrationData);
        if (result) {
            this.dssRegistrationLog.info(operationLog, "Data has been registered with the openBIS Application Server.");
        }
        return result;
    }

    private boolean registerDataWithRecovery(TechId registrationId, List<DataSetRegistrationInformation<T>> registrationData) {
        DistinctExceptionsCollection exceptionCollection = new DistinctExceptionsCollection();
        EntityOperationsState result = EntityOperationsState.NO_OPERATION;
        Throwable problem = null;
        int errorCount = 0;
        block8: while (true) {
            block11: {
                this.waitUntilApplicationIsReady();
                if (result == EntityOperationsState.NO_OPERATION) {
                    try {
                        AtomicEntityOperationResult entities = this.applicationServerRegistrator.registerDataSetsInApplicationServer(registrationId, registrationData);
                        this.dssRegistrationLog.info(operationLog, entities.toString());
                        return true;
                    }
                    catch (IncomingFileDeletedBeforeRegistrationException e) {
                        this.dssRegistrationLog.warn(operationLog, "The incoming file was deleted before registration. Nothing was registered in openBIS.");
                        this.rollbackDuringMetadataRegistration(e);
                        return false;
                    }
                    catch (Throwable exception) {
                        this.dssRegistrationLog.error(operationLog, "Error in registrating data in application server");
                        problem = exception;
                        errorCount = exceptionCollection.add(problem);
                        if (this.storageRecoveryManager.canRecoverFromError(problem)) break block11;
                        this.rollbackDuringMetadataRegistration(problem);
                        return false;
                    }
                }
            }
            operationLog.debug("Will check the status of registration");
            result = this.checkOperationsSucceededNoGiveUp(registrationId);
            operationLog.debug("The registration is in state: " + (Object)((Object)result));
            switch (result) {
                case IN_PROGRESS: {
                    operationLog.debug("The registration is in progress. Will wait until it's done.");
                    this.interruptOrWaitTheRetryPeriod(problem);
                    continue block8;
                }
                case NO_OPERATION: {
                    if (errorCount > this.registrationMaxRetryCount) {
                        this.dssRegistrationLog.info(operationLog, "The same error happened " + errorCount + " times. Will stop registration.");
                        this.rollbackDelegate.markReadyForRecovery(this, problem);
                        return false;
                    }
                    operationLog.debug("The same error happened for the " + errorCount + " time. Will continue retrying after " + this.registrationRetryPauseInSec + " seconds");
                    this.interruptOrWaitTheRetryPeriod(problem);
                    continue block8;
                }
                case OPERATION_SUCCEEDED: {
                    operationLog.debug("The registration is in progress. Will wait until it's done.");
                    return true;
                }
            }
        }
    }

    private void interruptOrWaitTheRetryPeriod(Throwable throwable) {
        Throwable rootCause = ExceptionUtils.getRootCause((Throwable)throwable);
        if (rootCause instanceof InterruptedException || rootCause instanceof InterruptedExceptionUnchecked) {
            throw CheckedExceptionTunnel.wrapIfNecessary(throwable);
        }
        this.waitTheRetryPeriod();
    }

    private EntityOperationsState checkOperationsSucceededNoGiveUp(TechId registrationId) {
        while (true) {
            try {
                EntityOperationsState result = this.applicationServerRegistrator.didEntityOperationsSucceeded(registrationId);
                return result;
            }
            catch (Exception exception) {
                operationLog.debug("Error in checking status of registration. Probably AS is down. Will wait.", exception);
                this.waitTheRetryPeriod();
                continue;
            }
            break;
        }
    }

    private void waitTheRetryPeriod() {
        ConcurrencyUtilities.sleep(this.registrationRetryPauseInSec * 1000);
    }

    private boolean preCommitStorageAlgorithms() {
        try {
            for (DataSetStorageAlgorithm<T> storageAlgorithm : this.dataSetStorageAlgorithms) {
                storageAlgorithm.preCommit();
            }
        }
        catch (Throwable throwable) {
            this.rollbackDuringStorageProcessorRun(throwable);
            return false;
        }
        this.logPreCommitMessage();
        return true;
    }

    private void executeJythonScriptsForPostRegistration() {
        try {
            this.postPreRegistrationHooks.executePostRegistration(this.registrationContextHolder);
        }
        catch (Throwable throwable) {
            this.dssRegistrationLog.warn(operationLog, "Post-registration action failed", throwable);
        }
    }

    private void rollbackStorageProcessors(Throwable ex) {
        if (!(ex instanceof IncomingFileDeletedBeforeRegistrationException)) {
            operationLog.error("Error during dataset registration: " + ExceptionUtils.getRootCauseMessage((Throwable)ex), ex);
        }
        if (ex instanceof Error && !(ex instanceof AssertionError)) {
            return;
        }
        int i = this.dataSetStorageAlgorithms.size() - 1;
        while (i >= 0) {
            DataSetStorageAlgorithm<T> storageAlgorithm = this.dataSetStorageAlgorithms.get(i);
            storageAlgorithm.transitionToRolledbackState(ex);
            storageAlgorithm.transitionToUndoneState();
            --i;
        }
    }

    private void logSuccessfulRegistration() {
        if (this.getOperationLog().isInfoEnabled()) {
            String msg = this.getSuccessRegistrationMessage();
            this.getOperationLog().info(msg);
        }
    }

    private final String getSuccessRegistrationMessage() {
        StringBuilder buffer = new StringBuilder();
        for (DataSetStorageAlgorithm<T> storageAlgorithm : this.dataSetStorageAlgorithms) {
            buffer.append(SUCCESSFULLY_REGISTERED);
            buffer.append(storageAlgorithm.getSuccessRegistrationMessage());
            buffer.append(']');
        }
        return buffer.toString();
    }

    public List<DataSetStorageAlgorithm<T>> getDataSetStorageAlgorithms() {
        return this.dataSetStorageAlgorithms;
    }

    public IRollbackStack getRollbackStack() {
        return this.rollbackStack;
    }

    public DssRegistrationLogger getDssRegistrationLogger() {
        return this.dssRegistrationLog;
    }

    private Logger getOperationLog() {
        return operationLog;
    }

    public DataSetFile getIncomingDataSetFile() {
        return this.incomingDataSetFile;
    }

    public DataSetRegistrationContext getRegistrationContext() {
        return this.registrationContextHolder.getRegistrationContext();
    }

    public static interface IDataSetInApplicationServerRegistrator<T extends DataSetInformation> {
        public AtomicEntityOperationResult registerDataSetsInApplicationServer(TechId var1, List<DataSetRegistrationInformation<T>> var2) throws Throwable;

        public EntityOperationsState didEntityOperationsSucceeded(TechId var1);
    }

    public static interface IPrePostRegistrationHook<T extends DataSetInformation> {
        public void executePreRegistration(DataSetRegistrationContext.IHolder var1);

        public void executePostRegistration(DataSetRegistrationContext.IHolder var1);
    }

    public static interface IRollbackDelegate<T extends DataSetInformation> {
        public void didRollbackStorageAlgorithmRunner(DataSetStorageAlgorithmRunner<T> var1, Throwable var2, IDataSetOnErrorActionDecision.ErrorType var3);

        public void markReadyForRecovery(DataSetStorageAlgorithmRunner<T> var1, Throwable var2);
    }

    public static class StorageProcessorTransactionCommand
    implements ITransactionalCommand {
        private static final long serialVersionUID = 1L;
        final IStorageProcessorTransactional.IStorageProcessorTransaction transaction;

        StorageProcessorTransactionCommand(IStorageProcessorTransactional.IStorageProcessorTransaction transaction) {
            this.transaction = transaction;
        }

        @Override
        public void execute() {
        }

        @Override
        public void rollback() {
            this.transaction.rollback(null);
        }
    }
}

