/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.archiveverifier.cli;

import ch.systemsx.cisd.openbis.dss.archiveverifier.batch.BatchResult;
import ch.systemsx.cisd.openbis.dss.archiveverifier.batch.DataSetArchiveVerificationResult;
import ch.systemsx.cisd.openbis.dss.archiveverifier.batch.DataSetArchiveVerifier;
import ch.systemsx.cisd.openbis.dss.archiveverifier.batch.IArchiveFileVerifier;
import ch.systemsx.cisd.openbis.dss.archiveverifier.batch.IDataSetArchiveVerificationBatch;
import ch.systemsx.cisd.openbis.dss.archiveverifier.batch.IDataSetArchiveVerifier;
import ch.systemsx.cisd.openbis.dss.archiveverifier.batch.SerialDataSetArchiveVerificationBatch;
import ch.systemsx.cisd.openbis.dss.archiveverifier.batch.VerificationErrorType;
import ch.systemsx.cisd.openbis.dss.archiveverifier.filesystem.FileSystemArchiveFileRepository;
import ch.systemsx.cisd.openbis.dss.archiveverifier.filesystem.FlatFileLocator;
import ch.systemsx.cisd.openbis.dss.archiveverifier.filesystem.IFileLocator;
import ch.systemsx.cisd.openbis.dss.archiveverifier.filesystem.ShardingFileLocator;
import ch.systemsx.cisd.openbis.dss.archiveverifier.pathinfo.JdbcPathInfoRepository;
import ch.systemsx.cisd.openbis.dss.archiveverifier.verifier.CompositeVerifier;
import ch.systemsx.cisd.openbis.dss.archiveverifier.verifier.CrcEnabled;
import ch.systemsx.cisd.openbis.dss.archiveverifier.verifier.IArchiveFileMetaDataRepository;
import ch.systemsx.cisd.openbis.dss.archiveverifier.verifier.ZipFileHeaderVerifier;
import ch.systemsx.cisd.openbis.dss.archiveverifier.verifier.ZipFileIntegrityVerifier;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;

public class DataSetArchiveVerificationBatchFactory {
    private final String[] args;
    private String servicePropertiesPath;
    private static final String DEFAULT_ARCHIVE_FOLDER = "archiver.default-archive-folder";
    private static final String MAPPING_FILE = "archiver.mapping-file";
    private static final String SHARDING = "archiver.with-sharding";
    private static final String DATABASE_NAME = "path-info-db.basicDatabaseName";
    private static final String DATABASE_KIND = "path-info-db.databaseKind";
    private static final String DATABASE_USER = "path-info-db.owner";
    private static final String DATABASE_PASSWORD = "path-info-db.password";
    private static final String PATHINFO_CHECKSUMS_COMPUTED = "post-registration.pathinfo-feeding.compute-checksum";

    public DataSetArchiveVerificationBatchFactory(String[] args) {
        this.args = args;
    }

    public IDataSetArchiveVerificationBatch build() {
        try {
            if (this.args.length < 2) {
                throw new ConfigurationException("Usage: datastore_server.sh verify-archives <dataset_code_1> <dataset_code_2> ...");
            }
            Properties properties = this.readServiceProperties(this.args[0]);
            File defaultArchiveDirectory = this.getDefaultArchiveDirectory(properties);
            IArchiveFileMetaDataRepository pathInfoRepository = this.getPathInfoRepository(properties);
            List<File> archiveDirectories = this.getArchiveDirectories(properties, defaultArchiveDirectory);
            FileSystemArchiveFileRepository archiveFileRepository = this.getArchiveFileRepository(properties, archiveDirectories);
            List<IArchiveFileVerifier> verifiers = this.getVerifiers(properties, pathInfoRepository);
            DataSetArchiveVerifier verifier = new DataSetArchiveVerifier(archiveFileRepository, new CompositeVerifier(verifiers));
            if (pathInfoRepository == null) {
                ArrayList<DataSetArchiveVerificationResult> init = new ArrayList<DataSetArchiveVerificationResult>();
                init.add(new DataSetArchiveVerificationResult(VerificationErrorType.GENERAL_WARNING, "pathinfo db not configured"));
                return new SerialDataSetArchiveVerificationBatch((IDataSetArchiveVerifier)verifier, init, Arrays.copyOfRange(this.args, 1, this.args.length));
            }
            return new SerialDataSetArchiveVerificationBatch((IDataSetArchiveVerifier)verifier, Arrays.copyOfRange(this.args, 1, this.args.length));
        }
        catch (ConfigurationException e) {
            final String error = e.getMessage();
            return new IDataSetArchiveVerificationBatch(){

                @Override
                public BatchResult run() {
                    BatchResult result = new BatchResult(new String[0]);
                    result.add("", new DataSetArchiveVerificationResult(VerificationErrorType.FATAL, error));
                    return result;
                }
            };
        }
    }

    private List<IArchiveFileVerifier> getVerifiers(Properties properties, IArchiveFileMetaDataRepository pathInfoRepository) {
        ArrayList<IArchiveFileVerifier> verifiers = new ArrayList<IArchiveFileVerifier>();
        verifiers.add(new ZipFileIntegrityVerifier());
        if (pathInfoRepository != null) {
            verifiers.add(new ZipFileHeaderVerifier(pathInfoRepository, "true".equalsIgnoreCase(properties.getProperty(PATHINFO_CHECKSUMS_COMPUTED)) ? CrcEnabled.TRUE : CrcEnabled.FALSE));
        }
        return verifiers;
    }

    private FileSystemArchiveFileRepository getArchiveFileRepository(Properties properties, List<File> archiveDirectories) {
        boolean sharding = "true".equalsIgnoreCase(properties.getProperty(SHARDING));
        IFileLocator fileLocator = sharding ? new ShardingFileLocator() : new FlatFileLocator();
        FileSystemArchiveFileRepository fileFinder = new FileSystemArchiveFileRepository(archiveDirectories, fileLocator);
        return fileFinder;
    }

    private List<File> getArchiveDirectories(Properties properties, File defaultArchiveDirectory) throws ConfigurationException {
        ArrayList<File> mappedArchiveDirectories = new ArrayList<File>();
        String mappingFilePath = properties.getProperty(MAPPING_FILE);
        if (mappingFilePath != null) {
            File mappingFile = new File(mappingFilePath);
            if (!mappingFile.exists()) {
                throw new ConfigurationException("Mapping file " + mappingFilePath + " does not exist");
            }
            try {
                String line;
                BufferedReader br = new BufferedReader(new FileReader(mappingFile));
                int lineNumber = 0;
                while ((line = br.readLine()) != null) {
                    if (++lineNumber == 1) continue;
                    String archiveDirectoryPath = line.substring(line.lastIndexOf("\t") + 1);
                    File archiveDirectory = new File(archiveDirectoryPath);
                    if (!archiveDirectory.exists()) {
                        throw new ConfigurationException("Archive directory " + archiveDirectoryPath + " specified in mapping file " + mappingFilePath + " does not exist");
                    }
                    mappedArchiveDirectories.add(archiveDirectory);
                }
                br.close();
            }
            catch (IOException e) {
                throw new ConfigurationException("I/O error: " + e.getMessage());
            }
        }
        ArrayList<File> archiveDirectories = new ArrayList<File>();
        archiveDirectories.add(defaultArchiveDirectory);
        archiveDirectories.addAll(mappedArchiveDirectories);
        return archiveDirectories;
    }

    private IArchiveFileMetaDataRepository getPathInfoRepository(Properties properties) throws ConfigurationException {
        JdbcPathInfoRepository pathInfoRepository = null;
        String databaseName = properties.getProperty(DATABASE_NAME);
        String databaseKind = properties.getProperty(DATABASE_KIND);
        if (databaseName != null && databaseKind != null) {
            String user = properties.getProperty(DATABASE_USER);
            String password = properties.getProperty(DATABASE_PASSWORD);
            if (user == null || user.isEmpty()) {
                user = "postgres";
            }
            if (password == null) {
                password = "";
            }
            String url = "jdbc:postgresql://localhost/" + databaseName + "_" + databaseKind;
            try {
                Connection connection = DriverManager.getConnection(url, user, password);
                pathInfoRepository = new JdbcPathInfoRepository(connection);
            }
            catch (SQLException sQLException) {
                throw new ConfigurationException("Could not connect to pathinfo db at " + url + " with user name '" + user + "', password '" + password + "'");
            }
        }
        return pathInfoRepository;
    }

    private File getDefaultArchiveDirectory(Properties properties) throws ConfigurationException {
        String defaultArchiveDirectoryPath = properties.getProperty(DEFAULT_ARCHIVE_FOLDER);
        if (defaultArchiveDirectoryPath == null) {
            throw new ConfigurationException(String.valueOf(this.servicePropertiesPath) + " does not contain mandatory property " + DEFAULT_ARCHIVE_FOLDER);
        }
        File defaultArchiveDirectory = new File(defaultArchiveDirectoryPath);
        if (!defaultArchiveDirectory.exists()) {
            throw new ConfigurationException("Default archive directory " + defaultArchiveDirectoryPath + " does not exist");
        }
        return defaultArchiveDirectory;
    }

    private Properties readServiceProperties(String path) throws ConfigurationException {
        File serviceProperties = new File(path);
        this.servicePropertiesPath = serviceProperties.getAbsolutePath();
        if (!serviceProperties.exists()) {
            throw new ConfigurationException("File " + this.servicePropertiesPath + " does not exist");
        }
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(serviceProperties));
        }
        catch (IOException ex) {
            throw new ConfigurationException("Could not read " + this.servicePropertiesPath + ": " + ex.getMessage());
        }
        return properties;
    }

    private class ConfigurationException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private final String message;

        public ConfigurationException(String message) {
            this.message = message;
        }

        @Override
        public String getMessage() {
            return this.message;
        }
    }
}

