/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.IShareIdManager;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PhysicalDataSet;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetShareId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class ShareIdManager
implements IShareIdManager {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, ShareIdManager.class);
    private final IEncapsulatedOpenBISService service;
    private final int lockingTimeOut;
    private final Map<String, Set<Thread>> lockedDataSets = new HashMap<String, Set<Thread>>();
    private final Object dataSetCodeToShareIdMapMonitor = new Object();
    private Map<String, GuardedShareID> dataSetCodeToShareIdMap;

    public ShareIdManager(IEncapsulatedOpenBISService service, String lockingTimeOutInSeconds) {
        this(service, ShareIdManager.parseAsInt(lockingTimeOutInSeconds, 84600));
    }

    private static int parseAsInt(String value, int defaultValue) {
        return value.startsWith("${") ? defaultValue : Integer.parseInt(value);
    }

    public ShareIdManager(IEncapsulatedOpenBISService service, int lockingTimeOutInSeconds) {
        this.service = service;
        this.lockingTimeOut = lockingTimeOutInSeconds;
    }

    private void addShareId(Map<String, GuardedShareID> map, String dataSetCode, String shareId) {
        GuardedShareID guardedShareId = new GuardedShareID(dataSetCode, shareId, this.lockingTimeOut);
        map.put(dataSetCode, guardedShareId);
    }

    @Override
    public boolean isKnown(String dataSetCode) {
        this.tryGetGuardedShareId(dataSetCode);
        return this.getDataSetCodeToShareIdMap().containsKey(dataSetCode);
    }

    @Override
    public String getShareId(String dataSetCode) {
        return this.getGuardedShareId(dataSetCode).getShareId();
    }

    @Override
    public void setShareId(String dataSetCode, String shareId) {
        Map<String, GuardedShareID> map = this.getDataSetCodeToShareIdMap();
        GuardedShareID guardedShareId = map.get(dataSetCode);
        if (guardedShareId != null) {
            guardedShareId.setShareId(shareId);
            operationLog.info("New share of data set " + dataSetCode + " is " + shareId);
        } else {
            this.addShareId(map, dataSetCode, shareId);
            operationLog.info("Register data set " + dataSetCode + " for share " + shareId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lock(String dataSetCode) {
        Map<String, Set<Thread>> map = this.lockedDataSets;
        synchronized (map) {
            Set<Thread> set = this.lockedDataSets.get(dataSetCode);
            if (set == null) {
                set = new LinkedHashSet<Thread>();
                GuardedShareID guardedShareId = this.getGuardedShareId(dataSetCode);
                this.lockedDataSets.put(dataSetCode, set);
                guardedShareId.lock();
                if (operationLog.isDebugEnabled()) {
                    Throwable th = new Throwable();
                    th.fillInStackTrace();
                    operationLog.debug("Data set " + dataSetCode + " has been locked.", th);
                }
            }
            set.add(Thread.currentThread());
            this.log(dataSetCode, set);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void lock(List<String> dataSetCodes) {
        var2_2 = this.lockedDataSets;
        synchronized (var2_2) {
            block9: {
                locked = new ArrayList<String>();
                try {
                    for (String dataSetCode : dataSetCodes) {
                        set = this.lockedDataSets.get(dataSetCode);
                        if (set == null) {
                            set = new LinkedHashSet<Thread>();
                            guardedShareId = this.getGuardedShareId(dataSetCode);
                            this.lockedDataSets.put(dataSetCode, set);
                            guardedShareId.lock();
                            if (ShareIdManager.operationLog.isDebugEnabled()) {
                                th = new Throwable();
                                th.fillInStackTrace();
                                ShareIdManager.operationLog.debug("Data set " + dataSetCode + " has been locked.", th);
                            }
                        }
                        set.add(Thread.currentThread());
                        locked.add(dataSetCode);
                        this.log(dataSetCode, set);
                    }
                    break block9;
                }
                catch (Throwable th) {
                    ** for (dataSetCode : locked)
                }
lbl-1000:
                // 1 sources

                {
                    this.releaseLock(dataSetCode);
                    continue;
                }
lbl30:
                // 1 sources

                throw CheckedExceptionTunnel.wrapIfNecessary(th);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void await(String dataSetCode) {
        block5: {
            map = this.getDataSetCodeToShareIdMap();
            guardedShareId = map.get(dataSetCode);
            if (guardedShareId != null) {
                block6: {
                    try {
                        guardedShareId.await();
                        break block5;
                    }
                    catch (EnvironmentFailureException ex) {
                        if (!ex.getMessage().contains("time out") || (set = this.lockedDataSets.get(dataSetCode)) == null) break block6;
                        b = new StringBuilder();
                        ** for (t : set)
                    }
lbl-1000:
                    // 1 sources

                    {
                        b.append(t.getName());
                        b.append(',');
                        continue;
                    }
lbl16:
                    // 1 sources

                    if (b.length() > 0) {
                        b.setLength(b.length() - 1);
                    }
                    ShareIdManager.operationLog.error("Timeout: Lock for data set " + dataSetCode + " is held by threads '" + b.toString() + "' for " + this.lockingTimeOut + " seconds.");
                }
                throw ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseLock(String dataSetCode) {
        Map<String, Set<Thread>> map = this.lockedDataSets;
        synchronized (map) {
            Set<Thread> set = this.lockedDataSets.get(dataSetCode);
            if (set == null) {
                return;
            }
            set.remove(Thread.currentThread());
            if (set.isEmpty()) {
                if (operationLog.isDebugEnabled()) {
                    operationLog.debug("Unlock data set " + dataSetCode);
                }
                this.lockedDataSets.remove(dataSetCode);
                this.getGuardedShareId(dataSetCode).unlock();
            }
            this.log(dataSetCode, set);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseLocks() {
        Map<String, Set<Thread>> map = this.lockedDataSets;
        synchronized (map) {
            ArrayList<String> dataSets = new ArrayList<String>(this.lockedDataSets.keySet());
            for (String dataSet : dataSets) {
                this.releaseLock(dataSet);
            }
        }
    }

    private void log(String dataSetCode, Set<Thread> set) {
        if (operationLog.isDebugEnabled() && !set.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            for (Thread thread : set) {
                if (builder.length() > 0) {
                    builder.append(", ");
                }
                builder.append(thread.getName());
            }
            operationLog.debug("Data set " + dataSetCode + " is locked by the following threads: " + builder);
        }
    }

    private GuardedShareID tryGetGuardedShareId(String dataSetCode) {
        GuardedShareID shareId = this.getDataSetCodeToShareIdMap().get(dataSetCode);
        if (shareId == null) {
            this.updateValueForDataSet(dataSetCode);
            shareId = this.getDataSetCodeToShareIdMap().get(dataSetCode);
        }
        return shareId;
    }

    private GuardedShareID getGuardedShareId(String dataSetCode) {
        GuardedShareID shareId = this.tryGetGuardedShareId(dataSetCode);
        if (shareId == null) {
            throw new IllegalArgumentException("Unknown data set: " + dataSetCode);
        }
        return shareId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, GuardedShareID> getDataSetCodeToShareIdMap() {
        Object object = this.dataSetCodeToShareIdMapMonitor;
        synchronized (object) {
            if (this.dataSetCodeToShareIdMap == null) {
                List<DataSetShareId> dataSets = this.service.listDataSetShareIds();
                this.dataSetCodeToShareIdMap = new HashMap<String, GuardedShareID>();
                for (DataSetShareId dataSet : dataSets) {
                    String dataSetCode = dataSet.getDataSetCode();
                    String shareId = dataSet.getShareId();
                    this.addShareId(this.dataSetCodeToShareIdMap, dataSetCode, shareId);
                }
                operationLog.info("Share id manager initialized with " + dataSets.size() + " data sets.");
            }
            return this.dataSetCodeToShareIdMap;
        }
    }

    private void updateValueForDataSet(String dataSetCode) {
        String shareId;
        AbstractExternalData abstractDataSet = this.service.tryGetLocalDataSet(dataSetCode);
        if (abstractDataSet == null) {
            return;
        }
        if (abstractDataSet instanceof PhysicalDataSet) {
            PhysicalDataSet dataSet = (PhysicalDataSet)abstractDataSet;
            shareId = dataSet.getShareId();
        } else {
            shareId = "1";
        }
        this.addShareId(this.dataSetCodeToShareIdMap, dataSetCode, shareId);
    }

    private static final class GuardedShareID {
        private final int lockingTimeOut;
        private final String dataSetCode;
        private CountDownLatch countDownLatch;
        private String shareId;

        GuardedShareID(String dataSetCode, String shareId, int lockingTimeOut) {
            this.dataSetCode = dataSetCode;
            this.shareId = shareId == null ? "1" : shareId;
            this.lockingTimeOut = lockingTimeOut;
        }

        String getShareId() {
            return this.shareId;
        }

        void setShareId(String shareId) {
            this.shareId = shareId;
        }

        void lock() {
            this.countDownLatch = new CountDownLatch(1);
        }

        void unlock() {
            if (this.countDownLatch != null) {
                this.countDownLatch.countDown();
            }
        }

        void await() {
            if (this.countDownLatch != null) {
                try {
                    boolean successful = this.countDownLatch.await(this.lockingTimeOut, TimeUnit.SECONDS);
                    if (!successful) {
                        throw new EnvironmentFailureException("Lock for data set " + this.dataSetCode + " hasn't been released after time out of " + this.lockingTimeOut + " seconds.");
                    }
                }
                catch (InterruptedException ex) {
                    throw CheckedExceptionTunnel.wrapIfNecessary(ex);
                }
            }
        }
    }
}

