/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.filesystem.tar.Untar;
import ch.systemsx.cisd.common.io.MonitoredIOStreamCopier;
import ch.systemsx.cisd.common.logging.ISimpleLogger;
import ch.systemsx.cisd.openbis.dss.generic.shared.ISingleDataSetPathInfoProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetPathInfo;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.lang.StringUtils;

class TarBasedPathInfoProvider
implements ISingleDataSetPathInfoProvider {
    private final File packageFile;
    private final int bufferSize;
    private final ISimpleLogger ioSpeedLogger;
    private Map<String, DataSetPathInfo> pathInfos;
    private Map<String, List<DataSetPathInfo>> pathInfoChildren;

    TarBasedPathInfoProvider(File packageFile, int bufferSize, ISimpleLogger ioSpeedLogger) {
        this.packageFile = packageFile;
        this.bufferSize = bufferSize;
        this.ioSpeedLogger = ioSpeedLogger;
    }

    @Override
    public DataSetPathInfo getRootPathInfo() {
        return this.tryGetPathInfoByRelativePath(Collections.min(this.getPathInfoChildren().keySet()));
    }

    @Override
    public DataSetPathInfo tryGetPathInfoByRelativePath(String relativePath) {
        return this.getPathInfos().get(relativePath);
    }

    @Override
    public List<DataSetPathInfo> listChildrenPathInfos(DataSetPathInfo parent) {
        return this.getPathInfoChildren().get(parent.getRelativePath());
    }

    @Override
    public List<DataSetPathInfo> listMatchingPathInfos(String relativePathPattern) {
        ArrayList<DataSetPathInfo> result = new ArrayList<DataSetPathInfo>();
        Pattern pattern = Pattern.compile(relativePathPattern);
        for (DataSetPathInfo pathInfo : this.getPathInfos().values()) {
            if (!pattern.matcher(pathInfo.getRelativePath()).matches()) continue;
            result.add(pathInfo);
        }
        return result;
    }

    @Override
    public List<DataSetPathInfo> listMatchingPathInfos(String startingPath, String fileNamePattern) {
        ArrayList<DataSetPathInfo> result = new ArrayList<DataSetPathInfo>();
        Pattern pattern = Pattern.compile(fileNamePattern);
        for (DataSetPathInfo pathInfo : this.getPathInfos().values()) {
            if (!pathInfo.getRelativePath().startsWith(startingPath) || !pattern.matcher(pathInfo.getFileName()).matches()) continue;
            result.add(pathInfo);
        }
        return result;
    }

    private Map<String, List<DataSetPathInfo>> getPathInfoChildren() {
        this.getPathInfos();
        return this.pathInfoChildren;
    }

    private Map<String, DataSetPathInfo> getPathInfos() {
        if (this.pathInfos == null) {
            MonitoredIOStreamCopier copier = new MonitoredIOStreamCopier(this.bufferSize);
            copier.setLogger(this.ioSpeedLogger);
            Untar untar = null;
            try {
                try {
                    this.pathInfos = new TreeMap<String, DataSetPathInfo>();
                    untar = new UntarMetaData(this.packageFile, copier, this.pathInfos);
                    untar.extract((File)null);
                    this.createPathInfoLinks();
                }
                catch (IOException ex) {
                    throw CheckedExceptionTunnel.wrapIfNecessary(ex);
                }
            }
            finally {
                if (untar != null) {
                    try {
                        untar.close();
                    }
                    catch (IOException e) {
                        throw CheckedExceptionTunnel.wrapIfNecessary(e);
                    }
                }
            }
        }
        return this.pathInfos;
    }

    private void createPathInfoLinks() {
        this.pathInfoChildren = new HashMap<String, List<DataSetPathInfo>>();
        for (DataSetPathInfo pathInfo : this.pathInfos.values()) {
            String relativePath = pathInfo.getRelativePath();
            String parentRelativePath = FileUtilities.getParentRelativePath(relativePath);
            if (!StringUtils.isNotBlank((String)parentRelativePath)) continue;
            DataSetPathInfo parentPathInfo = this.pathInfos.get(parentRelativePath);
            pathInfo.setParent(parentPathInfo);
            List<DataSetPathInfo> children = this.pathInfoChildren.get(parentRelativePath);
            if (children == null) {
                children = new ArrayList<DataSetPathInfo>();
                this.pathInfoChildren.put(parentRelativePath, children);
            }
            children.add(pathInfo);
        }
    }

    private static final void addDirectory(String path, Map<String, DataSetPathInfo> pathInfos) {
        if (StringUtils.isNotBlank((String)path) && !pathInfos.containsKey(path)) {
            DataSetPathInfo pathInfo = new DataSetPathInfo();
            pathInfo.setDirectory(true);
            pathInfo.setFileName(FileUtilities.getFileNameFromRelativePath(path));
            pathInfo.setRelativePath(path);
            pathInfos.put(path, pathInfo);
            TarBasedPathInfoProvider.addDirectory(FileUtilities.getParentRelativePath(path), pathInfos);
        }
    }

    private static final class PathInfoOutputStream
    extends FilterOutputStream {
        private final TarArchiveEntry entry;
        private final Map<String, DataSetPathInfo> pathInfos;
        private final Checksum checksum;
        private long fileSize;

        public PathInfoOutputStream(TarArchiveEntry entry, Map<String, DataSetPathInfo> pathInfos) {
            super((OutputStream)new NullOutputStream());
            this.entry = entry;
            this.pathInfos = pathInfos;
            this.checksum = new CRC32();
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
            this.checksum.update(b);
            ++this.fileSize;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
            this.checksum.update(b, off, len);
            this.fileSize += (long)len;
        }

        @Override
        public void close() throws IOException {
            super.close();
            String name = this.entry.getName();
            DataSetPathInfo pathInfo = new DataSetPathInfo();
            pathInfo.setChecksumCRC32((int)this.checksum.getValue());
            pathInfo.setDirectory(false);
            pathInfo.setFileName(FileUtilities.getFileNameFromRelativePath(name));
            pathInfo.setLastModified(this.entry.getLastModifiedDate());
            pathInfo.setRelativePath(name);
            pathInfo.setSizeInBytes(this.fileSize);
            this.pathInfos.put(name, pathInfo);
            TarBasedPathInfoProvider.addDirectory(FileUtilities.getParentRelativePath(name), this.pathInfos);
        }
    }

    private static final class UntarMetaData
    extends Untar {
        private Map<String, DataSetPathInfo> pathInfos;

        public UntarMetaData(File tarFile, MonitoredIOStreamCopier copier, Map<String, DataSetPathInfo> pathInfos) throws FileNotFoundException {
            super(tarFile, copier);
            this.pathInfos = pathInfos;
        }

        @Override
        protected OutputStream createOutputStream(File entryFile, TarArchiveEntry entry) throws IOException {
            return new PathInfoOutputStream(entry, this.pathInfos);
        }

        @Override
        protected void createDirectory(File directory) {
            TarBasedPathInfoProvider.addDirectory(directory.getPath(), this.pathInfos);
        }

        @Override
        protected void createParentDirectories(File file) {
        }

        @Override
        protected void createSymbolicLink(File file, TarArchiveEntry entry) {
        }

        @Override
        protected void createHardLink(File file, TarArchiveEntry entry) {
        }

        @Override
        protected void setFileMetadata(File entryFile, TarArchiveEntry entry) {
        }
    }
}

