/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins.tasks;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.collection.CollectionUtils;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.properties.ExtendedProperties;
import ch.systemsx.cisd.common.properties.PropertyParametersUtil;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.common.reflection.ClassUtils;
import ch.systemsx.cisd.common.spring.WhiteAndBlackListCodebaseAwareObjectInputStream;
import ch.systemsx.cisd.openbis.dss.generic.server.IServletPropertiesManager;
import ch.systemsx.cisd.openbis.dss.generic.server.api.v2.sequencedatabases.AbstractSearchDomainService;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.tasks.IReportingPluginTask;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v2.ISearchDomainService;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.DssPropertyParametersUtil;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatastoreServiceDescription;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ReportingPluginType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class PluginTaskFactory<T> {
    @Private
    public static final String LABEL_PROPERTY_NAME = "label";
    @Private
    public static final String DATASET_CODES_PROPERTY_NAME = "dataset-types";
    public static final String CLASS_PROPERTY_NAME = "class";
    @Private
    public static final String SERVLET_PROPERTY_NAME = "servlet";
    @Private
    public static final String SERVLETS_PROPERTY_NAME = "servlets";
    @Private
    public static final String PARAMS_FILE_PATH_PROPERTY_NAME = "properties-file";
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, PluginTaskFactory.class);
    private final DatastoreServiceDescription description;
    private final String className;
    private final Properties instanceParameters;
    private final T pluginInstance;
    private final String pluginTaskName;

    public PluginTaskFactory(IServletPropertiesManager servletPropertiesManager, PropertyParametersUtil.SectionProperties sectionProperties, String datastoreCode, Class<T> clazz, String pluginTaskName, File storeRoot) {
        this.pluginTaskName = pluginTaskName;
        Properties pluginProperties = sectionProperties.getProperties();
        WhiteAndBlackListCodebaseAwareObjectInputStream.populateWhiteAndBlackListOfApiParameterClasses(pluginProperties);
        String label = PropertyUtils.getMandatoryProperty(pluginProperties, LABEL_PROPERTY_NAME);
        ExtendedProperties props = ExtendedProperties.getSubset(pluginProperties, "servlet.", true);
        if (props.isEmpty()) {
            PropertyParametersUtil.SectionProperties[] servletsProperties = PropertyParametersUtil.extractSectionProperties(pluginProperties, SERVLETS_PROPERTY_NAME, false);
            if (servletsProperties.length > 0) {
                servletPropertiesManager.addServletsProperties(String.valueOf(label) + ", ", servletsProperties);
            }
        } else {
            servletPropertiesManager.addServletProperties(label, props);
        }
        String pluginKey = sectionProperties.getKey();
        this.className = PropertyUtils.getMandatoryProperty(pluginProperties, CLASS_PROPERTY_NAME);
        this.instanceParameters = PluginTaskFactory.extractInstanceParameters(pluginProperties);
        this.pluginInstance = this.createPluginInstance(clazz, storeRoot);
        if (this.pluginInstance instanceof IReportingPluginTask) {
            ReportingPluginType type = ((IReportingPluginTask)this.pluginInstance).getReportingPluginType();
            String[] datasetCodes = type == ReportingPluginType.AGGREGATION_TABLE_MODEL ? new String[]{} : PluginTaskFactory.extractDatasetCodes(pluginProperties);
            this.description = DatastoreServiceDescription.reporting(pluginKey, label, datasetCodes, datastoreCode, type);
        } else if (this.pluginInstance instanceof ISearchDomainService) {
            this.description = DatastoreServiceDescription.processing(pluginKey, label, new String[0], datastoreCode);
            if (this.pluginInstance instanceof AbstractSearchDomainService) {
                ((AbstractSearchDomainService)this.pluginInstance).setName(pluginKey);
            }
        } else {
            String[] datasetCodes = PluginTaskFactory.extractDatasetCodes(pluginProperties);
            this.description = DatastoreServiceDescription.processing(pluginKey, label, datasetCodes, datastoreCode);
        }
    }

    public void logConfiguration() {
        String key = this.getPluginDescription().getKey();
        operationLog.info(String.format(String.valueOf(this.pluginTaskName) + " '%s' configuration:", key));
        this.logPropertiesConfiguration();
    }

    public T getPluginInstance() {
        return this.pluginInstance;
    }

    private T createPluginInstance(Class<T> clazz, File storeRoot) {
        try {
            return ClassUtils.create(clazz, this.className, this.instanceParameters, storeRoot);
        }
        catch (Exception ex) {
            throw new ConfigurationFailureException("Cannot create the plugin class '" + this.className + "'", CheckedExceptionTunnel.unwrapIfNecessary(ex));
        }
    }

    private static Properties extractInstanceParameters(Properties pluginProperties) {
        String parametersFilePath = pluginProperties.getProperty(PARAMS_FILE_PATH_PROPERTY_NAME);
        Properties properties = new Properties();
        PluginTaskFactory.addAll(properties, pluginProperties);
        if (!StringUtils.isBlank((String)parametersFilePath)) {
            ExtendedProperties propertiesFromFile = DssPropertyParametersUtil.loadProperties(parametersFilePath);
            PluginTaskFactory.addAll(properties, propertiesFromFile);
        }
        return properties;
    }

    private static void addAll(Properties result, Properties propertiesToAdd) {
        for (Object key : propertiesToAdd.keySet()) {
            result.put(key, propertiesToAdd.get(key));
        }
    }

    private static String[] extractDatasetCodes(Properties pluginProperties) {
        String datasetCodesValues = PropertyUtils.getMandatoryProperty(pluginProperties, DATASET_CODES_PROPERTY_NAME);
        return PropertyParametersUtil.parseItemisedProperty(datasetCodesValues, DATASET_CODES_PROPERTY_NAME);
    }

    protected final void logPropertiesConfiguration() {
        if (operationLog.isInfoEnabled()) {
            this.logLine(LABEL_PROPERTY_NAME, this.description.getLabel());
            this.logLine(DATASET_CODES_PROPERTY_NAME, CollectionUtils.abbreviate(this.description.getDatasetTypeCodes(), -1));
            this.logLine(CLASS_PROPERTY_NAME, this.className);
            this.logLine(PARAMS_FILE_PATH_PROPERTY_NAME, this.instanceParameters.toString());
        }
    }

    private void logLine(String propertyName, String value) {
        operationLog.info(String.format("%s.%s = %s", this.description.getKey(), propertyName, value));
    }

    public void check(boolean checkIfSerializable) {
        if (checkIfSerializable) {
            this.checkInstanceSerializable();
        }
    }

    private void checkInstanceSerializable() {
        try {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(outStream);
            out.writeObject(this.pluginInstance);
            byte[] byteArray = outStream.toByteArray();
            ByteArrayInputStream inStream = new ByteArrayInputStream(byteArray);
            ObjectInputStream in = new ObjectInputStream(inStream);
            in.readObject();
        }
        catch (Exception ex) {
            this.throwSerializationError(ex.getMessage());
        }
    }

    private void throwSerializationError(String message) {
        throw UserFailureException.fromTemplate("Plugin '%s' has problems with serialization/deserialization: %s", this.pluginInstance.getClass().getName(), message);
    }

    public DatastoreServiceDescription getPluginDescription() {
        return this.description;
    }
}

