/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.shared.utils;

import ch.systemsx.cisd.common.filesystem.FileOperations;
import ch.systemsx.cisd.common.logging.ISimpleLogger;
import ch.systemsx.cisd.common.logging.LogLevel;
import ch.systemsx.cisd.common.utilities.ITimeProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.Share;
import ch.systemsx.cisd.openbis.generic.shared.dto.SimpleDataSetInformationDTO;
import java.io.File;
import java.util.Map;
import org.apache.commons.io.FileUtils;

final class SharesHolder {
    private final String dataStoreCode;
    private final Map<String, Share> shares;
    private final IEncapsulatedOpenBISService service;
    private final ISimpleLogger log;
    private final ITimeProvider timeProvider;
    private boolean areDataSetsAdded;

    SharesHolder(String dataStoreCode, Map<String, Share> shares, IEncapsulatedOpenBISService service, ISimpleLogger log, ITimeProvider timeProvider) {
        this.dataStoreCode = dataStoreCode;
        this.shares = shares;
        this.service = service;
        this.log = log;
        this.timeProvider = timeProvider;
    }

    void addDataSetsToStores() {
        if (this.areDataSetsAdded) {
            return;
        }
        for (SimpleDataSetInformationDTO dataSet : this.service.listPhysicalDataSets()) {
            String shareId = dataSet.getDataSetShareId();
            if (!this.dataStoreCode.equals(dataSet.getDataStoreCode())) continue;
            Share share = this.shares.get(shareId);
            String dataSetCode = dataSet.getDataSetCode();
            if (share == null) continue;
            if (dataSet.getDataSetSize() == null) {
                File dataSetInStore = new File(share.getShare(), dataSet.getDataSetLocation());
                if (FileOperations.getMonitoredInstanceForCurrentThread().exists(dataSetInStore)) {
                    this.log.log(LogLevel.INFO, "Calculating size of " + dataSetInStore);
                    long t0 = this.timeProvider.getTimeInMilliseconds();
                    long size = FileUtils.sizeOfDirectory((File)dataSetInStore);
                    this.log.log(LogLevel.INFO, dataSetInStore + " contains " + size + " bytes (calculated in " + (this.timeProvider.getTimeInMilliseconds() - t0) + " msec)");
                    this.service.updateShareIdAndSize(dataSetCode, shareId, size);
                    dataSet.setDataSetSize(size);
                } else {
                    this.log.log(LogLevel.WARN, "Data set " + dataSetCode + " no longer exists in share " + shareId + ".");
                }
            }
            if (dataSet.getDataSetSize() == null) continue;
            share.addDataSet(dataSet);
        }
        this.areDataSetsAdded = true;
    }
}

