/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.server.resultset;

import ch.systemsx.cisd.openbis.generic.client.web.client.dto.GridRowModels;
import ch.systemsx.cisd.openbis.generic.client.web.server.calculator.ITableDataProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.GridRowModel;
import ch.systemsx.cisd.openbis.generic.shared.basic.IColumnDefinition;
import ch.systemsx.cisd.openbis.generic.shared.basic.PrimitiveValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TableDataProviderFactory {
    static <T> ITableDataProvider createDataProvider(List<T> rows, List<IColumnDefinition<T>> availableColumns) {
        return new TableDataProviderForListOfRows(availableColumns, rows);
    }

    public static <T> ITableDataProvider createDataProvider(GridRowModels<T> rows, List<IColumnDefinition<T>> availableColumns) {
        return new TableDataProviderForGridRowModles(availableColumns, rows);
    }

    private static abstract class AbstractTableDataProvider<T>
    implements ITableDataProvider {
        protected final List<IColumnDefinition<T>> availableColumns;
        protected Map<String, Integer> indexMap;

        public AbstractTableDataProvider(List<IColumnDefinition<T>> availableColumns) {
            this.availableColumns = availableColumns;
        }

        @Override
        public String tryToGetProperty(String columnID, String key) {
            return this.getDefinition(columnID).tryToGetProperty(key);
        }

        @Override
        public Comparable<?> getValue(String columnID, List<? extends Comparable<?>> rowValues) {
            Integer index = this.indexMap.get(columnID);
            if (index == null) {
                throw new IllegalArgumentException("Unknown column ID: " + columnID);
            }
            return rowValues.get(index);
        }

        @Override
        public Collection<String> getAllColumnIDs() {
            ArrayList<String> result = new ArrayList<String>();
            for (IColumnDefinition<T> columnDefinition : this.availableColumns) {
                result.add(columnDefinition.getIdentifier());
            }
            return result;
        }

        @Override
        public List<String> getAllColumnTitles() {
            ArrayList<String> result = new ArrayList<String>();
            for (IColumnDefinition<T> columnDefinition : this.availableColumns) {
                result.add(columnDefinition.getHeader());
            }
            return result;
        }

        protected void createIndexMap(List<IColumnDefinition<T>> definitions) {
            this.indexMap = new HashMap<String, Integer>();
            int i = 0;
            while (i < definitions.size()) {
                IColumnDefinition<T> columnDefinition = definitions.get(i);
                this.indexMap.put(columnDefinition.getIdentifier(), i);
                ++i;
            }
        }

        protected IColumnDefinition<T> getDefinition(String columnID) {
            for (IColumnDefinition<T> definition : this.availableColumns) {
                if (!definition.getIdentifier().equals(columnID)) continue;
                return definition;
            }
            throw new IllegalArgumentException("Unknown column ID: " + columnID);
        }
    }

    private static final class TableDataProviderForGridRowModles<T>
    extends AbstractTableDataProvider<T> {
        private final GridRowModels<T> rows;

        private TableDataProviderForGridRowModles(List<IColumnDefinition<T>> availableColumns, GridRowModels<T> rows) {
            super(availableColumns);
            this.rows = rows;
        }

        @Override
        public List<List<? extends Comparable<?>>> getRows() {
            ArrayList definitions = new ArrayList(this.availableColumns);
            this.createIndexMap(definitions);
            ArrayList result = new ArrayList();
            for (GridRowModel gridRowModel : this.rows) {
                ArrayList<PrimitiveValue> rowValues = new ArrayList<PrimitiveValue>();
                for (IColumnDefinition iColumnDefinition : definitions) {
                    PrimitiveValue v = null;
                    if (iColumnDefinition.getClass().getSimpleName().contains("CustomColumn")) {
                        String identifier = iColumnDefinition.getIdentifier();
                        try {
                            v = gridRowModel.findColumnValue(identifier);
                        }
                        catch (IllegalStateException illegalStateException) {
                            v = null;
                        }
                    } else {
                        v = iColumnDefinition.tryGetComparableValue(gridRowModel);
                    }
                    rowValues.add(v);
                }
                result.add(rowValues);
            }
            return result;
        }
    }

    private static final class TableDataProviderForListOfRows<T>
    extends AbstractTableDataProvider<T> {
        private final List<T> rows;

        private TableDataProviderForListOfRows(List<IColumnDefinition<T>> availableColumns, List<T> rows) {
            super(availableColumns);
            this.rows = rows;
        }

        @Override
        public List<List<? extends Comparable<?>>> getRows() {
            ArrayList definitions = new ArrayList(this.availableColumns);
            this.createIndexMap(definitions);
            ArrayList result = new ArrayList();
            for (T row : this.rows) {
                ArrayList rowValues = new ArrayList();
                for (IColumnDefinition iColumnDefinition : definitions) {
                    Comparable<?> value = null;
                    try {
                        value = iColumnDefinition.tryGetComparableValue(GridRowModel.createWithoutCustomColumns(row));
                    }
                    catch (Exception exception) {}
                    rowValues.add(value);
                }
                result.add(rowValues);
            }
            return result;
        }
    }
}

