/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.migration;

import ch.systemsx.cisd.common.collection.CollectionUtils;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.reflection.ModifiedShortPrefixToStringStyle;
import ch.systemsx.cisd.dbmigration.java.MigrationStepAdapter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.log4j.Logger;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

public final class MigrationStepFrom025To026
extends MigrationStepAdapter {
    private static final String OBSERVABLE_TYPE_PREFIX = "/ObservableType_";
    private static final String DATA_SET_TYPE_PREFIX = "/DataSetType_";
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, MigrationStepFrom025To026.class);
    private static final ParameterizedRowMapper<ExternalData> EXTERNAL_DATA_ROW_MAPPER = new ParameterizedRowMapper<ExternalData>(){

        public final ExternalData mapRow(ResultSet rs, int rowNum) throws SQLException {
            long id = rs.getLong("data_id");
            String location = rs.getString("location");
            return new ExternalData(id, location);
        }
    };

    public static final String getNewLocation(String oldLocation) {
        int index = oldLocation.indexOf(OBSERVABLE_TYPE_PREFIX);
        if (index < 0) {
            StringBuilder builder = new StringBuilder();
            builder.append("WARNING: ");
            builder.append("No ");
            builder.append(OBSERVABLE_TYPE_PREFIX);
            builder.append(" found in external data location '");
            builder.append(oldLocation);
            builder.append("'.");
            operationLog.warn(builder.toString());
            return oldLocation;
        }
        return oldLocation.replaceFirst(OBSERVABLE_TYPE_PREFIX, DATA_SET_TYPE_PREFIX);
    }

    @Override
    public final void performPostMigration(SimpleJdbcTemplate simpleJdbcTemplate, DataSource dataSource) throws DataAccessException {
        List externalDatas = simpleJdbcTemplate.query(String.format("select data_id, location from %s", "external_data"), EXTERNAL_DATA_ROW_MAPPER, new Object[0]);
        if (externalDatas.size() == 0) {
            operationLog.info("No data set location has been migrated.");
        } else {
            ArrayList<ExternalData> migrated = new ArrayList<ExternalData>();
            for (ExternalData externalData : externalDatas) {
                String oldLocation = externalData.location;
                String newLocation = MigrationStepFrom025To026.getNewLocation(externalData.location);
                if (newLocation.equals(oldLocation)) continue;
                int updated = simpleJdbcTemplate.update(String.format("update %s set location = ? where data_id = ?", "external_data"), new Object[]{newLocation, externalData.id});
                if (updated != 1) {
                    throw new IncorrectResultSizeDataAccessException(1, updated);
                }
                migrated.add(externalData);
            }
            operationLog.info(String.format("Following data set locations '%s' have been migrated.", CollectionUtils.abbreviate(migrated, 10)));
        }
    }

    static final class ExternalData {
        final long id;
        final String location;

        ExternalData(long id, String location) {
            this.id = id;
            this.location = location;
        }

        public final String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ModifiedShortPrefixToStringStyle.MODIFIED_SHORT_PREFIX_STYLE);
        }
    }
}

