/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.task;

import ch.systemsx.cisd.authentication.IAuthenticationService;
import ch.systemsx.cisd.authentication.stacked.StackedAuthenticationService;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.maintenance.IMaintenanceTask;
import ch.systemsx.cisd.openbis.generic.server.CommonServiceProvider;
import ch.systemsx.cisd.openbis.generic.server.ICommonServerForInternalUse;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IPersonDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IRoleAssignmentDAO;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AuthorizationGroup;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Person;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.RoleAssignmentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SessionContextDTO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;

public class RevokeUserAccessMaintenanceTask
implements IMaintenanceTask {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, RevokeUserAccessMaintenanceTask.class);
    private static final String AUTH_SERVICE_BEAN = "authentication-service";
    private static final IAuthenticationService authService;

    static {
        IAuthenticationService authServiceAux = (IAuthenticationService)CommonServiceProvider.tryToGetBean(AUTH_SERVICE_BEAN);
        authService = authServiceAux instanceof StackedAuthenticationService && ((StackedAuthenticationService)authServiceAux).allServicesSupportListingByUserId() ? authServiceAux : (authServiceAux.supportsListingByUserId() ? authServiceAux : null);
    }

    @Override
    public void setUp(String pluginName, Properties properties) {
        operationLog.info("Task " + pluginName + " initialized.");
    }

    @Override
    public void execute() {
        operationLog.info("execution started");
        if (authService == null) {
            operationLog.info("This plugin doesn't work with authentication services that don't support listing by user idt.");
            return;
        }
        IPersonDAO personDAO = CommonServiceProvider.getDAOFactory().getPersonDAO();
        IRoleAssignmentDAO rolesDAO = CommonServiceProvider.getDAOFactory().getRoleAssignmentDAO();
        ICommonServerForInternalUse server = CommonServiceProvider.getCommonServer();
        SessionContextDTO contextOrNull = server.tryToAuthenticateAsSystem();
        List<PersonPE> people = personDAO.listActivePersons();
        ArrayList<PersonPE> peopleToRevoke = new ArrayList<PersonPE>();
        block0: for (PersonPE person : people) {
            if (person.isSystemUser() || !person.isActive() || this.isUserValid(person.getUserId())) continue;
            List<RoleAssignmentPE> roles = rolesDAO.listRoleAssignmentsByPerson(person);
            for (RoleAssignmentPE role : roles) {
                if (role.getRole().name().equals("ETL_SERVER")) continue block0;
            }
            peopleToRevoke.add(person);
        }
        for (PersonPE person : peopleToRevoke) {
            String userIdToRevoke = person.getUserId();
            operationLog.info("person " + userIdToRevoke + " is going to be revoked.");
            for (RoleAssignmentPE role : rolesDAO.listRoleAssignmentsByPerson(person)) {
                rolesDAO.delete(role);
            }
            List<AuthorizationGroup> groups = server.listAuthorizationGroups(contextOrNull.getSessionToken());
            for (AuthorizationGroup group : groups) {
                List<Person> peopleInGroup = server.listPersonInAuthorizationGroup(contextOrNull.getSessionToken(), new TechId(group.getId()));
                for (Person personInGroup : peopleInGroup) {
                    if (!personInGroup.getUserId().equals(userIdToRevoke)) continue;
                    ArrayList<String> toRemoveFromGroup = new ArrayList<String>();
                    toRemoveFromGroup.add(person.getUserId());
                    server.removePersonsFromAuthorizationGroup(contextOrNull.getSessionToken(), new TechId(group.getId()), toRemoveFromGroup);
                }
            }
            person.setUserId(String.valueOf(person.getUserId()) + "-" + this.getTimeStamp());
            person.setActive(false);
            personDAO.updatePerson(person);
            operationLog.info("person " + userIdToRevoke + " has been revoked.");
        }
        operationLog.info("task executed");
    }

    private boolean isUserValid(String userId) {
        return authService.supportsListingByUserId() && !authService.listPrincipalsByUserId(userId).isEmpty();
    }

    private String getTimeStamp() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy.MM.dd");
        return dateFormat.format(new Date());
    }
}

