/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util;

import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.util.HierarchicalUriComponents;
import org.springframework.web.util.OpaqueUriComponents;
import org.springframework.web.util.UriComponents;

public class UriComponentsBuilder
implements Cloneable {
    private static final Pattern QUERY_PARAM_PATTERN = Pattern.compile("([^&=]+)(=?)([^&]+)?");
    private static final String SCHEME_PATTERN = "([^:/?#]+):";
    private static final String HTTP_PATTERN = "(?i)(http|https):";
    private static final String USERINFO_PATTERN = "([^@\\[/?#]*)";
    private static final String HOST_IPV4_PATTERN = "[^\\[/?#:]*";
    private static final String HOST_IPV6_PATTERN = "\\[[\\p{XDigit}\\:\\.]*[%\\p{Alnum}]*\\]";
    private static final String HOST_PATTERN = "(\\[[\\p{XDigit}\\:\\.]*[%\\p{Alnum}]*\\]|[^\\[/?#:]*)";
    private static final String PORT_PATTERN = "(\\d*(?:\\{[^/]+?\\})?)";
    private static final String PATH_PATTERN = "([^?#]*)";
    private static final String QUERY_PATTERN = "([^#]*)";
    private static final String LAST_PATTERN = "(.*)";
    private static final Pattern URI_PATTERN = Pattern.compile("^(([^:/?#]+):)?(//(([^@\\[/?#]*)@)?(\\[[\\p{XDigit}\\:\\.]*[%\\p{Alnum}]*\\]|[^\\[/?#:]*)(:(\\d*(?:\\{[^/]+?\\})?))?)?([^?#]*)(\\?([^#]*))?(#(.*))?");
    private static final Pattern HTTP_URL_PATTERN = Pattern.compile("^(?i)(http|https):(//(([^@\\[/?#]*)@)?(\\[[\\p{XDigit}\\:\\.]*[%\\p{Alnum}]*\\]|[^\\[/?#:]*)(:(\\d*(?:\\{[^/]+?\\})?))?)?([^?#]*)(\\?(.*))?");
    private String scheme;
    private String ssp;
    private String userInfo;
    private String host;
    private String port;
    private CompositePathComponentBuilder pathBuilder;
    private final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
    private String fragment;

    protected UriComponentsBuilder() {
        this.pathBuilder = new CompositePathComponentBuilder();
    }

    protected UriComponentsBuilder(UriComponentsBuilder other) {
        this.scheme = other.scheme;
        this.ssp = other.ssp;
        this.userInfo = other.userInfo;
        this.host = other.host;
        this.port = other.port;
        this.pathBuilder = (CompositePathComponentBuilder)other.pathBuilder.clone();
        this.queryParams.putAll(other.queryParams);
        this.fragment = other.fragment;
    }

    public static UriComponentsBuilder newInstance() {
        return new UriComponentsBuilder();
    }

    public static UriComponentsBuilder fromPath(String path) {
        UriComponentsBuilder builder = new UriComponentsBuilder();
        builder.path(path);
        return builder;
    }

    public static UriComponentsBuilder fromUri(URI uri) {
        UriComponentsBuilder builder = new UriComponentsBuilder();
        builder.uri(uri);
        return builder;
    }

    public static UriComponentsBuilder fromUriString(String uri) {
        Assert.hasLength(uri, "'uri' must not be empty");
        Matcher matcher = URI_PATTERN.matcher(uri);
        if (matcher.matches()) {
            String rest;
            UriComponentsBuilder builder = new UriComponentsBuilder();
            String scheme = matcher.group(2);
            String userInfo = matcher.group(5);
            String host = matcher.group(6);
            String port = matcher.group(8);
            String path = matcher.group(9);
            String query = matcher.group(11);
            String fragment = matcher.group(13);
            boolean opaque = false;
            if (StringUtils.hasLength(scheme) && !(rest = uri.substring(scheme.length())).startsWith(":/")) {
                opaque = true;
            }
            builder.scheme(scheme);
            if (opaque) {
                String ssp = uri.substring(scheme.length()).substring(1);
                if (StringUtils.hasLength(fragment)) {
                    ssp = ssp.substring(0, ssp.length() - (fragment.length() + 1));
                }
                builder.schemeSpecificPart(ssp);
            } else {
                builder.userInfo(userInfo);
                builder.host(host);
                if (StringUtils.hasLength(port)) {
                    builder.port(port);
                }
                builder.path(path);
                builder.query(query);
            }
            if (StringUtils.hasText(fragment)) {
                builder.fragment(fragment);
            }
            return builder;
        }
        throw new IllegalArgumentException("[" + uri + "] is not a valid URI");
    }

    public static UriComponentsBuilder fromHttpUrl(String httpUrl) {
        Assert.notNull(httpUrl, "'httpUrl' must not be null");
        Matcher matcher = HTTP_URL_PATTERN.matcher(httpUrl);
        if (matcher.matches()) {
            UriComponentsBuilder builder = new UriComponentsBuilder();
            String scheme = matcher.group(1);
            builder.scheme(scheme != null ? scheme.toLowerCase() : null);
            builder.userInfo(matcher.group(4));
            String host = matcher.group(5);
            if (StringUtils.hasLength(scheme) && !StringUtils.hasLength(host)) {
                throw new IllegalArgumentException("[" + httpUrl + "] is not a valid HTTP URL");
            }
            builder.host(host);
            String port = matcher.group(7);
            if (StringUtils.hasLength(port)) {
                builder.port(port);
            }
            builder.path(matcher.group(8));
            builder.query(matcher.group(10));
            return builder;
        }
        throw new IllegalArgumentException("[" + httpUrl + "] is not a valid HTTP URL");
    }

    public UriComponents build() {
        return this.build(false);
    }

    public UriComponents build(boolean encoded) {
        if (this.ssp != null) {
            return new OpaqueUriComponents(this.scheme, this.ssp, this.fragment);
        }
        return new HierarchicalUriComponents(this.scheme, this.userInfo, this.host, this.port, this.pathBuilder.build(), this.queryParams, this.fragment, encoded, true);
    }

    public UriComponents buildAndExpand(Map<String, ?> uriVariables) {
        return this.build(false).expand(uriVariables);
    }

    public UriComponents buildAndExpand(Object ... uriVariableValues) {
        return this.build(false).expand(uriVariableValues);
    }

    public String toUriString() {
        return this.build(false).encode().toUriString();
    }

    public UriComponentsBuilder uri(URI uri) {
        Assert.notNull(uri, "'uri' must not be null");
        this.scheme = uri.getScheme();
        if (uri.isOpaque()) {
            this.ssp = uri.getRawSchemeSpecificPart();
            this.resetHierarchicalComponents();
        } else {
            if (uri.getRawUserInfo() != null) {
                this.userInfo = uri.getRawUserInfo();
            }
            if (uri.getHost() != null) {
                this.host = uri.getHost();
            }
            if (uri.getPort() != -1) {
                this.port = String.valueOf(uri.getPort());
            }
            if (StringUtils.hasLength(uri.getRawPath())) {
                this.pathBuilder = new CompositePathComponentBuilder(uri.getRawPath());
            }
            if (StringUtils.hasLength(uri.getRawQuery())) {
                this.queryParams.clear();
                this.query(uri.getRawQuery());
            }
            this.resetSchemeSpecificPart();
        }
        if (uri.getRawFragment() != null) {
            this.fragment = uri.getRawFragment();
        }
        return this;
    }

    private void resetHierarchicalComponents() {
        this.userInfo = null;
        this.host = null;
        this.port = null;
        this.pathBuilder = new CompositePathComponentBuilder();
        this.queryParams.clear();
    }

    private void resetSchemeSpecificPart() {
        this.ssp = null;
    }

    public UriComponentsBuilder scheme(String scheme) {
        this.scheme = scheme;
        return this;
    }

    public UriComponentsBuilder uriComponents(UriComponents uriComponents) {
        Assert.notNull(uriComponents, "'uriComponents' must not be null");
        this.scheme = uriComponents.getScheme();
        if (uriComponents instanceof OpaqueUriComponents) {
            this.ssp = uriComponents.getSchemeSpecificPart();
            this.resetHierarchicalComponents();
        } else {
            if (uriComponents.getUserInfo() != null) {
                this.userInfo = uriComponents.getUserInfo();
            }
            if (uriComponents.getHost() != null) {
                this.host = uriComponents.getHost();
            }
            if (uriComponents.getPort() != -1) {
                this.port = String.valueOf(uriComponents.getPort());
            }
            if (StringUtils.hasLength(uriComponents.getPath())) {
                List<String> segments = uriComponents.getPathSegments();
                if (segments.isEmpty()) {
                    this.pathBuilder.addPath(uriComponents.getPath());
                } else {
                    this.pathBuilder.addPathSegments(segments.toArray(new String[segments.size()]));
                }
            }
            if (!uriComponents.getQueryParams().isEmpty()) {
                this.queryParams.clear();
                this.queryParams.putAll(uriComponents.getQueryParams());
            }
            this.resetSchemeSpecificPart();
        }
        if (uriComponents.getFragment() != null) {
            this.fragment = uriComponents.getFragment();
        }
        return this;
    }

    public UriComponentsBuilder schemeSpecificPart(String ssp) {
        this.ssp = ssp;
        this.resetHierarchicalComponents();
        return this;
    }

    public UriComponentsBuilder userInfo(String userInfo) {
        this.userInfo = userInfo;
        this.resetSchemeSpecificPart();
        return this;
    }

    public UriComponentsBuilder host(String host) {
        this.host = host;
        this.resetSchemeSpecificPart();
        return this;
    }

    public UriComponentsBuilder port(int port) {
        Assert.isTrue(port >= -1, "'port' must not be < -1");
        this.port = String.valueOf(port);
        this.resetSchemeSpecificPart();
        return this;
    }

    public UriComponentsBuilder port(String port) {
        this.port = port;
        this.resetSchemeSpecificPart();
        return this;
    }

    public UriComponentsBuilder path(String path) {
        this.pathBuilder.addPath(path);
        this.resetSchemeSpecificPart();
        return this;
    }

    public UriComponentsBuilder replacePath(String path) {
        this.pathBuilder = new CompositePathComponentBuilder(path);
        this.resetSchemeSpecificPart();
        return this;
    }

    public UriComponentsBuilder pathSegment(String ... pathSegments) throws IllegalArgumentException {
        Assert.notNull(pathSegments, "'segments' must not be null");
        this.pathBuilder.addPathSegments(pathSegments);
        this.resetSchemeSpecificPart();
        return this;
    }

    public UriComponentsBuilder query(String query) {
        if (query != null) {
            Matcher matcher = QUERY_PARAM_PATTERN.matcher(query);
            while (matcher.find()) {
                String name = matcher.group(1);
                String eq = matcher.group(2);
                String value = matcher.group(3);
                this.queryParam(name, value != null ? value : (StringUtils.hasLength(eq) ? "" : null));
            }
        } else {
            this.queryParams.clear();
        }
        this.resetSchemeSpecificPart();
        return this;
    }

    public UriComponentsBuilder replaceQuery(String query) {
        this.queryParams.clear();
        this.query(query);
        this.resetSchemeSpecificPart();
        return this;
    }

    public UriComponentsBuilder queryParam(String name, Object ... values) {
        Assert.notNull(name, "'name' must not be null");
        if (!ObjectUtils.isEmpty(values)) {
            for (Object value : values) {
                String valueAsString = value != null ? value.toString() : null;
                this.queryParams.add(name, valueAsString);
            }
        } else {
            this.queryParams.add(name, null);
        }
        this.resetSchemeSpecificPart();
        return this;
    }

    public UriComponentsBuilder queryParams(MultiValueMap<String, String> params) {
        Assert.notNull(params, "'params' must not be null");
        this.queryParams.putAll(params);
        return this;
    }

    public UriComponentsBuilder replaceQueryParam(String name, Object ... values) {
        Assert.notNull(name, "'name' must not be null");
        this.queryParams.remove(name);
        if (!ObjectUtils.isEmpty(values)) {
            this.queryParam(name, values);
        }
        this.resetSchemeSpecificPart();
        return this;
    }

    public UriComponentsBuilder fragment(String fragment) {
        if (fragment != null) {
            Assert.hasLength(fragment, "'fragment' must not be empty");
            this.fragment = fragment;
        } else {
            this.fragment = null;
        }
        return this;
    }

    protected Object clone() {
        return new UriComponentsBuilder(this);
    }

    private static class PathSegmentComponentBuilder
    implements PathComponentBuilder {
        private final List<String> pathSegments = new LinkedList<String>();

        private PathSegmentComponentBuilder() {
        }

        public void append(String ... pathSegments) {
            for (String pathSegment : pathSegments) {
                if (!StringUtils.hasText(pathSegment)) continue;
                this.pathSegments.add(pathSegment);
            }
        }

        @Override
        public HierarchicalUriComponents.PathComponent build() {
            return this.pathSegments.isEmpty() ? null : new HierarchicalUriComponents.PathSegmentComponent(this.pathSegments);
        }

        @Override
        public Object clone() {
            PathSegmentComponentBuilder builder = new PathSegmentComponentBuilder();
            builder.pathSegments.addAll(this.pathSegments);
            return builder;
        }
    }

    private static class FullPathComponentBuilder
    implements PathComponentBuilder {
        private final StringBuilder path = new StringBuilder();

        private FullPathComponentBuilder() {
        }

        public void append(String path) {
            this.path.append(path);
        }

        @Override
        public HierarchicalUriComponents.PathComponent build() {
            int index;
            if (this.path.length() == 0) {
                return null;
            }
            String path = this.path.toString();
            while ((index = path.indexOf("//")) != -1) {
                path = path.substring(0, index) + path.substring(index + 1);
            }
            return new HierarchicalUriComponents.FullPathComponent(path);
        }

        public void removeTrailingSlash() {
            int index = this.path.length() - 1;
            if (this.path.charAt(index) == '/') {
                this.path.deleteCharAt(index);
            }
        }

        @Override
        public Object clone() {
            FullPathComponentBuilder builder = new FullPathComponentBuilder();
            builder.append(this.path.toString());
            return builder;
        }
    }

    private static class CompositePathComponentBuilder
    implements PathComponentBuilder {
        private final LinkedList<PathComponentBuilder> builders = new LinkedList();

        public CompositePathComponentBuilder() {
        }

        public CompositePathComponentBuilder(String path) {
            this.addPath(path);
        }

        public void addPathSegments(String ... pathSegments) {
            if (!ObjectUtils.isEmpty(pathSegments)) {
                PathSegmentComponentBuilder psBuilder = this.getLastBuilder(PathSegmentComponentBuilder.class);
                FullPathComponentBuilder fpBuilder = this.getLastBuilder(FullPathComponentBuilder.class);
                if (psBuilder == null) {
                    psBuilder = new PathSegmentComponentBuilder();
                    this.builders.add(psBuilder);
                    if (fpBuilder != null) {
                        fpBuilder.removeTrailingSlash();
                    }
                }
                psBuilder.append(pathSegments);
            }
        }

        public void addPath(String path) {
            if (StringUtils.hasText(path)) {
                PathSegmentComponentBuilder psBuilder = this.getLastBuilder(PathSegmentComponentBuilder.class);
                FullPathComponentBuilder fpBuilder = this.getLastBuilder(FullPathComponentBuilder.class);
                if (psBuilder != null) {
                    String string = path = path.startsWith("/") ? path : "/" + path;
                }
                if (fpBuilder == null) {
                    fpBuilder = new FullPathComponentBuilder();
                    this.builders.add(fpBuilder);
                }
                fpBuilder.append(path);
            }
        }

        private <T> T getLastBuilder(Class<T> builderClass) {
            PathComponentBuilder last;
            if (!this.builders.isEmpty() && builderClass.isInstance(last = this.builders.getLast())) {
                return (T)last;
            }
            return null;
        }

        @Override
        public HierarchicalUriComponents.PathComponent build() {
            int size = this.builders.size();
            ArrayList<HierarchicalUriComponents.PathComponent> components = new ArrayList<HierarchicalUriComponents.PathComponent>(size);
            for (PathComponentBuilder componentBuilder : this.builders) {
                HierarchicalUriComponents.PathComponent pathComponent = componentBuilder.build();
                if (pathComponent == null) continue;
                components.add(pathComponent);
            }
            if (components.isEmpty()) {
                return HierarchicalUriComponents.NULL_PATH_COMPONENT;
            }
            if (components.size() == 1) {
                return (HierarchicalUriComponents.PathComponent)components.get(0);
            }
            return new HierarchicalUriComponents.PathComponentComposite(components);
        }

        @Override
        public Object clone() {
            CompositePathComponentBuilder compositeBuilder = new CompositePathComponentBuilder();
            for (PathComponentBuilder builder : this.builders) {
                compositeBuilder.builders.add((PathComponentBuilder)builder.clone());
            }
            return compositeBuilder;
        }
    }

    private static interface PathComponentBuilder
    extends Cloneable {
        public HierarchicalUriComponents.PathComponent build();

        public Object clone();
    }
}

