/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.asapi.v3.dto.space;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.ICodeHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IDescriptionHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IModificationDateHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IPermIdHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IProjectsHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IRegistrationDateHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.IRegistratorHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.interfaces.ISamplesHolder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.Person;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.Project;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.Sample;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.space.fetchoptions.SpaceFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.space.id.SpacePermId;
import ch.ethz.sis.openbis.generic.asapi.v3.exceptions.NotFetchedException;
import ch.systemsx.cisd.base.annotation.JsonObject;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

@JsonObject(value="as.dto.space.Space")
public class Space
implements Serializable,
ICodeHolder,
IDescriptionHolder,
IModificationDateHolder,
IPermIdHolder,
IProjectsHolder,
IRegistrationDateHolder,
IRegistratorHolder,
ISamplesHolder {
    private static final long serialVersionUID = 1L;
    @JsonProperty
    private SpaceFetchOptions fetchOptions;
    @JsonProperty
    private SpacePermId permId;
    @JsonProperty
    private String code;
    @JsonProperty
    private String description;
    @JsonProperty
    private Date registrationDate;
    @JsonProperty
    private Date modificationDate;
    @JsonProperty
    private Person registrator;
    @JsonProperty
    private List<Sample> samples;
    @JsonProperty
    private List<Project> projects;

    @JsonIgnore
    public SpaceFetchOptions getFetchOptions() {
        return this.fetchOptions;
    }

    public void setFetchOptions(SpaceFetchOptions fetchOptions) {
        this.fetchOptions = fetchOptions;
    }

    @Override
    @JsonIgnore
    public SpacePermId getPermId() {
        return this.permId;
    }

    public void setPermId(SpacePermId permId) {
        this.permId = permId;
    }

    @Override
    @JsonIgnore
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @Override
    @JsonIgnore
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    @JsonIgnore
    public Date getRegistrationDate() {
        return this.registrationDate;
    }

    public void setRegistrationDate(Date registrationDate) {
        this.registrationDate = registrationDate;
    }

    @Override
    @JsonIgnore
    public Date getModificationDate() {
        return this.modificationDate;
    }

    public void setModificationDate(Date modificationDate) {
        this.modificationDate = modificationDate;
    }

    @Override
    @JsonIgnore
    public Person getRegistrator() {
        if (this.getFetchOptions() != null && this.getFetchOptions().hasRegistrator()) {
            return this.registrator;
        }
        throw new NotFetchedException("Registrator has not been fetched.");
    }

    public void setRegistrator(Person registrator) {
        this.registrator = registrator;
    }

    @Override
    @JsonIgnore
    public List<Sample> getSamples() {
        if (this.getFetchOptions() != null && this.getFetchOptions().hasSamples()) {
            return this.samples;
        }
        throw new NotFetchedException("Samples have not been fetched.");
    }

    public void setSamples(List<Sample> samples) {
        this.samples = samples;
    }

    @Override
    @JsonIgnore
    public List<Project> getProjects() {
        if (this.getFetchOptions() != null && this.getFetchOptions().hasProjects()) {
            return this.projects;
        }
        throw new NotFetchedException("Projects have not been fetched.");
    }

    public void setProjects(List<Project> projects) {
        this.projects = projects;
    }

    public String toString() {
        return "Space " + this.permId;
    }
}

