/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.asapi.v3.exceptions;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import java.util.Iterator;
import java.util.List;

public class UnauthorizedObjectAccessException
extends UserFailureException {
    private static final long serialVersionUID = 1L;
    private IObjectId objectId;
    private List<? extends IObjectId> objectIds;

    public UnauthorizedObjectAccessException(IObjectId id) {
        super("Access denied to object with " + id.getClass().getSimpleName() + " = [" + id + "].");
        this.objectId = id;
    }

    public UnauthorizedObjectAccessException(List<? extends IObjectId> ids) {
        super("Access denied to at least one of the " + ids.size() + " = [" + UnauthorizedObjectAccessException.abbreviate(ids, 100) + "].");
        this.objectIds = ids;
    }

    private static String abbreviate(List<? extends IObjectId> ids, int maxSize) {
        StringBuilder builder = new StringBuilder();
        Iterator<? extends IObjectId> iterator = ids.iterator();
        int i = 0;
        while (iterator.hasNext() && i < maxSize) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(iterator.next());
            ++i;
        }
        int size = ids.size();
        if (maxSize < size) {
            builder.append(", ... (").append(size - maxSize).append(" left)");
        }
        return builder.toString();
    }

    public IObjectId getObjectId() {
        return this.objectId;
    }

    public List<? extends IObjectId> getObjectIds() {
        return this.objectIds;
    }
}

