/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.asapi.v3.dto.webapp.fetchoptions;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.fetchoptions.EmptyFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.fetchoptions.FetchIgnore;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.fetchoptions.FetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.fetchoptions.FetchOptionsToStringBuilder;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.fetchoptions.FetchProperty;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.webapp.WebAppSettings;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.webapp.fetchoptions.WebAppSettingsFetchOptionsAllSettingsHandler;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.webapp.fetchoptions.WebAppSettingsFetchOptionsSettingsHandler;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.webapp.fetchoptions.WebAppSettingsSortOptions;
import ch.systemsx.cisd.base.annotation.JsonObject;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;

@JsonObject(value="as.dto.webapp.fetchoptions.WebAppSettingsFetchOptions")
public class WebAppSettingsFetchOptions
extends FetchOptions<WebAppSettings>
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty
    @FetchProperty(handler=WebAppSettingsFetchOptionsSettingsHandler.class)
    private Collection<String> settings;
    @JsonProperty
    @FetchProperty(handler=WebAppSettingsFetchOptionsAllSettingsHandler.class)
    private boolean allSettings = false;
    @JsonProperty
    private WebAppSettingsSortOptions sort;

    @FetchIgnore
    public void withSetting(String setting) {
        if (this.settings == null) {
            this.settings = new HashSet<String>();
        }
        this.settings.add(setting);
    }

    @FetchIgnore
    public boolean hasSetting(String setting) {
        return this.settings != null && this.settings.contains(setting);
    }

    @FetchIgnore
    public Collection<String> withSettingsUsing(Collection<String> settings) {
        this.settings = settings;
        return this.settings;
    }

    @FetchIgnore
    public Collection<String> getSettings() {
        return this.settings;
    }

    @FetchIgnore
    public void withAllSettings() {
        this.allSettings = true;
    }

    @FetchIgnore
    public boolean hasAllSettings() {
        return this.allSettings;
    }

    @FetchIgnore
    public boolean withAllSettingsUsing(boolean allSettings) {
        this.allSettings = allSettings;
        return this.allSettings;
    }

    @JsonIgnore
    public WebAppSettingsSortOptions sortBy() {
        if (this.sort == null) {
            this.sort = new WebAppSettingsSortOptions();
        }
        return this.sort;
    }

    @JsonIgnore
    public WebAppSettingsSortOptions getSortBy() {
        return this.sort;
    }

    @Override
    protected FetchOptionsToStringBuilder getFetchOptionsStringBuilder() {
        FetchOptionsToStringBuilder f = new FetchOptionsToStringBuilder("WebAppSettings", this);
        if (this.settings != null && !this.settings.isEmpty()) {
            f.addFetchOption("Settings " + this.settings, new EmptyFetchOptions());
        }
        if (this.allSettings) {
            f.addFetchOption("AllSettings", new EmptyFetchOptions());
        }
        return f;
    }
}

