/*
 * Decompiled with CFR 0.152.
 */
package com.filemaker.jdbc;

import com.filemaker.jdbc.FMStream;
import com.filemaker.jdbc.MessageBlock;
import com.filemaker.jdbc.ProtocolMessage;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public class FMExecuteRequest
extends ProtocolMessage {
    private static final short CMD_FM_EXECUTE_REQUEST = 101;
    private int parameterCount;
    private int commandID;
    private long maxLength;

    public FMExecuteRequest(int n, long l, int n2) {
        super((short)101);
        this.parameterCount = 0;
        this.commandID = n;
        this.maxLength = l;
        this.addParameter16(this.commandID);
        this.addParameter16(this.parameterCount);
    }

    public FMExecuteRequest(byte[] byArray) {
        super(byArray);
    }

    short setParameterValue(int n, short s, short s2, long l, byte[] byArray) {
        this.addParameter16(n);
        this.addParameter8(s);
        this.addParameter8(s2);
        this.addParameter64(l);
        this.addParameter(byArray);
        ++this.parameterCount;
        return 0;
    }

    short setParameterValue(int n, short s, InputStream inputStream) {
        int n2 = 0x100000;
        byte[] byArray = new byte[n2];
        int n3 = 0;
        int n4 = 0;
        try {
            while (true) {
                int n5;
                if ((n5 = inputStream.read(byArray, n3, n2 - n3)) == -1) {
                    if (n3 > 0) {
                        this.addParameter16(n);
                        this.addParameter8(s);
                        this.addParameter8((short)0);
                        this.addParameter64(n3);
                        this.addParameter(byArray, n3);
                        ++this.parameterCount;
                        n4 += n3;
                    }
                    break;
                }
                if ((n3 += n5) != n2) continue;
                this.addParameter16(n);
                this.addParameter8(s);
                this.addParameter8((short)0);
                this.addParameter64(n3);
                this.addParameter(byArray);
                ++this.parameterCount;
                n4 += n3;
                n3 = 0;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return 0;
    }

    short setParameterValue(int n, short s, short s2, long l, String string) {
        this.addParameter16(n);
        this.addParameter8(s);
        this.addParameter8(s2);
        try {
            this.addParameter64(string.getBytes("UTF-8").length);
            this.addParameter(string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        ++this.parameterCount;
        return 0;
    }

    public boolean extract() {
        this.commandID = this.getParameter16();
        this.parameterCount = this.getParameter16();
        this.maxLength = this.getParameter64();
        this.extracted = true;
        return true;
    }

    public int getCommandID() {
        if (!this.extracted) {
            this.extract();
        }
        return this.commandID;
    }

    public long getMaxLength() {
        if (!this.extracted) {
            this.extract();
        }
        return this.maxLength;
    }

    public static String asHex(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        for (int i = 0; i < byArray.length; ++i) {
            if ((byArray[i] & 0xFF) < 16) {
                stringBuffer.append("0");
            }
            stringBuffer.append(Long.toString(byArray[i] & 0xFF, 16));
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public boolean send(FMStream fMStream) {
        MessageBlock messageBlock = (MessageBlock)this.messageBlocks.get(0);
        messageBlock.setItemCount(7, this.parameterCount);
        this.addParameter64(this.maxLength);
        return super.send(fMStream);
    }
}

