/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server.reactive;

import io.undertow.connector.ByteBufferPool;
import io.undertow.connector.PooledByteBuffer;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import io.undertow.util.HeaderValues;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.List;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.http.HttpCookie;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.AbstractListenerReadPublisher;
import org.springframework.http.server.reactive.AbstractServerHttpRequest;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.xnio.channels.StreamSourceChannel;
import reactor.core.publisher.Flux;

class UndertowServerHttpRequest
extends AbstractServerHttpRequest {
    private final HttpServerExchange exchange;
    private final RequestBodyPublisher body;

    public UndertowServerHttpRequest(HttpServerExchange exchange2, DataBufferFactory bufferFactory) {
        super(UndertowServerHttpRequest.initUri(exchange2), "", UndertowServerHttpRequest.initHeaders(exchange2));
        this.exchange = exchange2;
        this.body = new RequestBodyPublisher(exchange2, bufferFactory);
        this.body.registerListeners(exchange2);
    }

    private static URI initUri(HttpServerExchange exchange2) {
        Assert.notNull((Object)exchange2, "HttpServerExchange is required.");
        String requestURL = exchange2.getRequestURL();
        String query = exchange2.getQueryString();
        String requestUriAndQuery = StringUtils.isEmpty(query) ? requestURL : requestURL + "?" + query;
        return URI.create(requestUriAndQuery);
    }

    private static HttpHeaders initHeaders(HttpServerExchange exchange2) {
        HttpHeaders headers = new HttpHeaders();
        for (HeaderValues values : exchange2.getRequestHeaders()) {
            headers.put(values.getHeaderName().toString(), (List<String>)values);
        }
        return headers;
    }

    @Override
    public String getMethodValue() {
        return this.exchange.getRequestMethod().toString();
    }

    @Override
    protected MultiValueMap<String, HttpCookie> initCookies() {
        LinkedMultiValueMap<String, HttpCookie> cookies = new LinkedMultiValueMap<String, HttpCookie>();
        for (String name : this.exchange.getRequestCookies().keySet()) {
            Cookie cookie = (Cookie)this.exchange.getRequestCookies().get(name);
            HttpCookie httpCookie = new HttpCookie(name, cookie.getValue());
            cookies.add(name, httpCookie);
        }
        return cookies;
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this.exchange.getSourceAddress();
    }

    @Override
    public Flux<DataBuffer> getBody() {
        return Flux.from((Publisher)this.body);
    }

    @Override
    public <T> T getNativeRequest() {
        return (T)this.exchange;
    }

    private static class RequestBodyPublisher
    extends AbstractListenerReadPublisher<DataBuffer> {
        private final StreamSourceChannel channel;
        private final DataBufferFactory bufferFactory;
        private final ByteBufferPool byteBufferPool;
        @Nullable
        private PooledByteBuffer pooledByteBuffer;

        public RequestBodyPublisher(HttpServerExchange exchange2, DataBufferFactory bufferFactory) {
            this.channel = exchange2.getRequestChannel();
            this.bufferFactory = bufferFactory;
            this.byteBufferPool = exchange2.getConnection().getByteBufferPool();
        }

        private void registerListeners(HttpServerExchange exchange2) {
            exchange2.addExchangeCompleteListener((ex, next) -> {
                this.onAllDataRead();
                next.proceed();
            });
            this.channel.getReadSetter().set(c -> this.onDataAvailable());
            this.channel.getCloseSetter().set(c -> this.onAllDataRead());
            this.channel.resumeReads();
        }

        @Override
        protected void checkOnDataAvailable() {
            this.onDataAvailable();
        }

        @Override
        @Nullable
        protected DataBuffer read() throws IOException {
            if (this.pooledByteBuffer == null) {
                this.pooledByteBuffer = this.byteBufferPool.allocate();
            }
            ByteBuffer byteBuffer = this.pooledByteBuffer.getBuffer();
            byteBuffer.clear();
            int read = this.channel.read(byteBuffer);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("read:" + read);
            }
            if (read > 0) {
                byteBuffer.flip();
                return this.bufferFactory.wrap(byteBuffer);
            }
            if (read == -1) {
                this.onAllDataRead();
            }
            return null;
        }

        @Override
        public void onAllDataRead() {
            if (this.pooledByteBuffer != null && this.pooledByteBuffer.isOpen()) {
                this.pooledByteBuffer.close();
            }
            super.onAllDataRead();
        }
    }
}

