/*
 * Decompiled with CFR 0.152.
 */
package com.filemaker.jdbc3;

import com.filemaker.jdbc.Driver;
import com.filemaker.jdbc2.optional.ConnectionPool;
import com.filemaker.jdbc2.optional.PoolingDataSource;
import com.filemaker.jdbc3.J3ConnectionPool;
import com.filemaker.jdbc3.J3ObjectFactory;
import java.util.HashMap;
import java.util.Map;
import javax.naming.Reference;

public class J3PoolingDataSource
extends PoolingDataSource {
    private static Map dataSources = new HashMap();

    static J3PoolingDataSource getDataSource(String string) {
        return (J3PoolingDataSource)dataSources.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeStoredDataSource() {
        Map map = dataSources;
        synchronized (map) {
            dataSources.remove(this.dataSourceName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDataSourceName(String string) {
        if (this.isInitialized()) {
            throw new IllegalStateException("Cannot set Data Source properties after DataSource has been used");
        }
        if (this.dataSourceName != null && string != null && string.equals(this.dataSourceName)) {
            return;
        }
        Map map = dataSources;
        synchronized (map) {
            if (J3PoolingDataSource.getDataSource(string) != null) {
                throw new IllegalArgumentException("DataSource with name '" + string + "' already exists!");
            }
            if (this.dataSourceName != null) {
                dataSources.remove(this.dataSourceName);
            }
            this.dataSourceName = string;
            dataSources.put(string, this);
        }
    }

    protected Reference createReference() {
        return new Reference(this.getClass().getName(), J3ObjectFactory.class.getName(), null);
    }

    protected ConnectionPool createConnectionPool() {
        return new J3ConnectionPool();
    }

    public String getDescription() {
        return "JDBC3 Pooling DataSource from " + Driver.getVersion();
    }
}

