/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.rewrite.handler;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.rewrite.handler.RuleContainer;
import org.eclipse.jetty.util.ArrayUtil;

public class VirtualHostRuleContainer
extends RuleContainer {
    private String[] _virtualHosts;

    public void setVirtualHosts(String[] virtualHosts) {
        if (virtualHosts == null) {
            this._virtualHosts = virtualHosts;
        } else {
            this._virtualHosts = new String[virtualHosts.length];
            for (int i = 0; i < virtualHosts.length; ++i) {
                this._virtualHosts[i] = this.normalizeHostname(virtualHosts[i]);
            }
        }
    }

    public String[] getVirtualHosts() {
        return this._virtualHosts;
    }

    public void addVirtualHost(String virtualHost) {
        this._virtualHosts = ArrayUtil.addToArray(this._virtualHosts, virtualHost, String.class);
    }

    @Override
    public String matchAndApply(String target, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this._virtualHosts != null && this._virtualHosts.length > 0) {
            String requestHost = this.normalizeHostname(request.getServerName());
            for (String ruleHost : this._virtualHosts) {
                if (ruleHost != null && !ruleHost.equalsIgnoreCase(requestHost) && (!ruleHost.startsWith("*.") || !ruleHost.regionMatches(true, 2, requestHost, requestHost.indexOf(".") + 1, ruleHost.length() - 2))) continue;
                return this.apply(target, request, response);
            }
        } else {
            return this.apply(target, request, response);
        }
        return null;
    }

    private String normalizeHostname(String host) {
        if (host == null) {
            return null;
        }
        if (host.endsWith(".")) {
            return host.substring(0, host.length() - 1);
        }
        return host;
    }
}

