/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.logging;

import java.io.PrintStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Optional;

public final class LoggerDiagnostics {
    private static final PrintStream out = System.out;
    private static final PrintStream err = System.err;
    private static final Level CURRENT_LEVEL = Optional.ofNullable(System.getProperty("loggerdiagnostics.level")).map(String::toUpperCase).map(Level::valueOf).orElse(Level.INFO);
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss,SSS");

    private LoggerDiagnostics() {
    }

    public static void debug(Object message) {
        if (CURRENT_LEVEL.allows(Level.DEBUG)) {
            out.println(LoggerDiagnostics.format(Level.DEBUG, String.valueOf(message)));
        }
    }

    public static void info(Object message) {
        if (CURRENT_LEVEL.allows(Level.INFO)) {
            out.println(LoggerDiagnostics.format(Level.INFO, String.valueOf(message)));
        }
    }

    public static void warn(Object message) {
        if (CURRENT_LEVEL.allows(Level.WARN)) {
            out.println(LoggerDiagnostics.format(Level.WARN, String.valueOf(message)));
        }
    }

    public static void error(Object message) {
        if (CURRENT_LEVEL.allows(Level.ERROR)) {
            err.println(LoggerDiagnostics.format(Level.ERROR, String.valueOf(message)));
        }
    }

    public static void error(Object message, Throwable t) {
        if (CURRENT_LEVEL.allows(Level.ERROR)) {
            err.println(LoggerDiagnostics.format(Level.ERROR, String.valueOf(message)));
            t.printStackTrace(err);
        }
    }

    private static String format(Level level, String msg) {
        String timestamp = DATE_FORMAT.format(LocalDateTime.now());
        String lvl = String.format("%-5s", level.name());
        String thread = Thread.currentThread().getName();
        String category = LoggerDiagnostics.callerClassName();
        return String.format("%s %-5s [%s] %s - %s", timestamp, lvl, thread, category, msg);
    }

    private static String callerClassName() {
        for (StackTraceElement e : Thread.currentThread().getStackTrace()) {
            String cn = e.getClassName();
            if (cn.equals(LoggerDiagnostics.class.getName()) || cn.equals(PrintStreamAdapter.class.getName()) || cn.startsWith("java.lang.Thread")) continue;
            int dot = cn.lastIndexOf(46);
            return dot >= 0 ? cn.substring(dot + 1) : cn;
        }
        return "Unknown";
    }

    private static class PrintStreamAdapter
    extends PrintStream {
        private final Level level;
        private final StringBuilder buffer = new StringBuilder();

        PrintStreamAdapter(Level level) {
            super(System.err);
            this.level = level;
        }

        @Override
        public void write(int b) {
            char c = (char)b;
            if (c == '\n') {
                this.flushBuffer();
            } else {
                this.buffer.append(c);
                if (this.buffer.length() > 2048) {
                    this.flushBuffer();
                }
            }
        }

        @Override
        public void flush() {
            this.flushBuffer();
        }

        private void flushBuffer() {
            if (this.buffer.length() == 0) {
                return;
            }
            String msg = this.buffer.toString().trim();
            this.buffer.setLength(0);
            out.println(LoggerDiagnostics.format(this.level, msg));
        }
    }

    public static enum Level {
        DEBUG,
        INFO,
        WARN,
        ERROR,
        OFF;


        public boolean allows(Level messageLevel) {
            return this.ordinal() <= messageLevel.ordinal();
        }
    }
}

