/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.logging.ext;

import ch.systemsx.cisd.common.logging.ext.AbstractFileHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.charset.Charset;

public class SingleFileHandler
extends AbstractFileHandler {
    public SingleFileHandler(String logFileName, int maxLogFileSize, boolean append, boolean forceReInit) throws IOException {
        this(logFileName, maxLogFileSize, append, forceReInit, DEFAULT_ENCODING);
    }

    public SingleFileHandler(String logFileName, int maxLogFileSize, boolean append, boolean forceReInit, Charset encoding) throws IOException {
        super(logFileName, maxLogFileSize, append, encoding);
        this.openActiveFile(forceReInit);
    }

    private void openActiveFile(boolean forceReInit) throws IOException {
        this.currentFile = new File(this.logFileName);
        File parent = this.currentFile.getParentFile();
        if (!(parent == null || parent.exists() || parent.mkdirs() || parent.isDirectory())) {
            throw new IOException("Failed to create parent directories for log file: " + String.valueOf(parent));
        }
        if (!this.append && this.currentFile.exists() && !forceReInit) {
            File[] existing;
            for (File file : existing = parent.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith(SingleFileHandler.this.currentFile.getName()) && name.substring(SingleFileHandler.this.currentFile.getName().length()).matches("_\\d+");
                }
            })) {
                if (file.delete()) continue;
                throw new IOException("Failed to delete existing log file: " + String.valueOf(file));
            }
            if (!this.currentFile.delete()) {
                throw new IOException("Failed to delete existing log file: " + String.valueOf(this.currentFile));
            }
        }
        this.outputStream = new FileOutputStream(this.currentFile, this.append || forceReInit);
        this.currentSize = this.currentFile.exists() ? this.currentFile.length() : 0L;
    }

    private void rotateBySize(byte[] bytes) throws IOException {
        File parentDir = this.currentFile.getParentFile() != null ? this.currentFile.getParentFile() : new File(".");
        String prefix = new File(this.logFileName).getName() + "_";
        int nextIndex = SingleFileHandler.getNextIndex(parentDir, prefix);
        File archive = new File(parentDir, prefix + nextIndex);
        String currentFilePath = this.currentFile.getPath();
        this.currentFile.renameTo(archive);
        this.close();
        this.currentFile = new File(currentFilePath);
        this.outputStream = new FileOutputStream(this.currentFile, false);
        this.currentSize = 0L;
    }

    @Override
    public void customPublishLogic(byte[] bytes) throws IOException {
        if (this.maxLogFileSize > 0 && this.currentSize + (long)bytes.length > (long)this.maxLogFileSize) {
            this.rotateBySize(bytes);
        }
    }
}

