/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.filetransfer;

import ch.ethz.sis.filetransfer.DefaultChunkSerializer;
import ch.ethz.sis.filetransfer.DownloadException;
import ch.ethz.sis.filetransfer.IChunkSerializer;
import ch.ethz.sis.filetransfer.IDownloadItemId;
import ch.ethz.sis.filetransfer.IDownloadItemIdSerializer;
import ch.ethz.sis.filetransfer.ILogger;
import ch.ethz.sis.filetransfer.ISerializerProvider;

public class DefaultSerializerProvider
implements ISerializerProvider {
    private ILogger logger;
    private IDownloadItemIdSerializer itemIdSerializer;

    public DefaultSerializerProvider(ILogger logger) {
        this(new IDownloadItemIdSerializer(){

            @Override
            public byte[] serialize(IDownloadItemId itemId) throws DownloadException {
                return itemId.getId().getBytes();
            }
        }, logger);
    }

    public DefaultSerializerProvider(IDownloadItemIdSerializer itemIdSerializer, ILogger logger) {
        this.logger = logger;
        this.itemIdSerializer = itemIdSerializer;
    }

    @Override
    public IChunkSerializer createChunkSerializer() {
        return new DefaultChunkSerializer(this.logger, this.itemIdSerializer);
    }
}

