/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.args4j;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.HandlerClasses;
import org.kohsuke.args4j.IllegalAnnotationError;
import org.kohsuke.args4j.Messages;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.spi.EnumOptionHandler;
import org.kohsuke.args4j.spi.OptionHandler;
import org.kohsuke.args4j.spi.Setter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CmdLineOptions {
    private final Map<String, OptionHandler> options = new HashMap<String, OptionHandler>();
    private final List<OptionHandler> handlers = new ArrayList<OptionHandler>();
    private boolean sorted;

    CmdLineOptions() {
    }

    Collection<OptionHandler> getHandlers() {
        if (!this.sorted) {
            Collections.sort(this.handlers, new Comparator<OptionHandler>(){

                @Override
                public int compare(OptionHandler h1, OptionHandler h2) {
                    String n1 = h1.getName();
                    String n2 = h2.getName();
                    return n1.compareTo(n2);
                }
            });
            this.sorted = true;
        }
        return this.handlers;
    }

    void addOption(Setter setter, Option o) {
        if ("".equals(o.name()) && "".equals(o.longName())) {
            throw new IllegalAnnotationError("Option does have neither a short name nor a long name");
        }
        OptionHandler h = this.createOptionHandler(o, setter);
        String name = h.getName();
        String longName = h.getLongName();
        if (name.length() > 0 && this.options.put(name, h) != null) {
            throw new IllegalAnnotationError("Option name " + name + " is used more than once");
        }
        if (longName.length() > 0 && this.options.put(longName, h) != null) {
            throw new IllegalAnnotationError("Option name " + longName + " is used more than once");
        }
        this.handlers.add(h);
    }

    private OptionHandler createOptionHandler(Option o, Setter setter) {
        Constructor<? extends OptionHandler> handlerType;
        Class<? extends OptionHandler> h = o.handler();
        if (h == OptionHandler.class) {
            Class t = setter.getType();
            if (Enum.class.isAssignableFrom(t)) {
                return new EnumOptionHandler(o, setter, t);
            }
            handlerType = HandlerClasses.handlerClasses.get(t);
            if (handlerType == null) {
                throw new IllegalAnnotationError("No OptionHandler is registered to handle " + t);
            }
        } else {
            handlerType = HandlerClasses.getConstructor(h);
        }
        try {
            return handlerType.newInstance(o, setter);
        }
        catch (InstantiationException e) {
            throw new IllegalAnnotationError(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalAnnotationError(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalAnnotationError(e);
        }
    }

    void checkRequiredOptionsPresent(Set<OptionHandler> present) throws CmdLineException {
        StringBuilder builder = new StringBuilder();
        for (OptionHandler handler : this.getHandlers()) {
            if (!handler.isRequired() || present.contains(handler)) continue;
            builder.append(handler.getName()).append(", ");
        }
        if (builder.length() > 0) {
            builder.setLength(builder.length() - 2);
            throw new CmdLineException(String.valueOf(Messages.REQUIRED_OPTION_MISSING.format(new Object[0])) + builder);
        }
    }

    OptionHandler getHandlerForOption(String arg) {
        return this.options.get(arg);
    }

    int getMaxOptionPrintLength(ResourceBundle rb) {
        int maxLen = 0;
        for (OptionHandler handler : this.options.values()) {
            String usage = handler.getUsage();
            if (usage.length() == 0) continue;
            String metaVar = handler.getMetaVariable(rb);
            int metaLen = metaVar != null ? metaVar.length() + 1 : 0;
            int nameLen = handler.getName().length();
            int longNameLen = handler.getLongName().length();
            int len = nameLen + longNameLen + metaLen;
            if (nameLen > 0 && longNameLen > 0) {
                len += 3;
            }
            maxLen = Math.max(maxLen, len);
        }
        return maxLen;
    }
}

