/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.bds;

import ch.systemsx.cisd.bds.IDataStructure;
import ch.systemsx.cisd.bds.IDataStructureHandler;
import ch.systemsx.cisd.bds.Version;
import ch.systemsx.cisd.bds.exception.DataStructureException;
import ch.systemsx.cisd.bds.storage.IDirectory;
import ch.systemsx.cisd.bds.storage.IStorage;
import java.util.ArrayList;
import java.util.List;

abstract class AbstractDataStructure
implements IDataStructure,
IDataStructureHandler {
    protected final IStorage storage;
    protected IDirectory root;
    private final List<IDataStructureHandler> handlers;

    AbstractDataStructure(IStorage storage) {
        assert (storage != null) : "Unspecified storage.";
        this.storage = storage;
        this.handlers = new ArrayList<IDataStructureHandler>();
    }

    private void mountStorage() {
        this.storage.mount();
        this.root = this.storage.getRoot();
    }

    protected final void registerHandler(IDataStructureHandler handler) {
        assert (handler != null) : "Given handler can not be null.";
        this.handlers.add(handler);
    }

    protected final void assertOpenOrCreated() {
        if (this.root == null) {
            throw new IllegalStateException("Data structure should first be opened or created.");
        }
    }

    protected void afterCreation() {
    }

    public void assertValid() {
        for (IDataStructureHandler handler : this.handlers) {
            handler.assertValid();
        }
    }

    public void performOpening() {
        for (IDataStructureHandler handler : this.handlers) {
            handler.performOpening();
        }
    }

    public void performClosing() {
        for (IDataStructureHandler handler : this.handlers) {
            handler.performClosing();
        }
    }

    public final void create() {
        this.mountStorage();
        this.afterCreation();
    }

    public final void open() {
        this.mountStorage();
        this.performOpening();
        Version loadedVersion = Version.loadFrom(this.root);
        if (!loadedVersion.isBackwardsCompatibleWith(this.getVersion())) {
            throw new DataStructureException("Version of loaded data structure is " + loadedVersion + " which is not backward compatible with " + this.getVersion());
        }
        this.assertValid();
    }

    public final void close() {
        this.assertOpenOrCreated();
        this.getVersion().saveTo(this.root);
        this.performClosing();
        this.assertValid();
        this.storage.unmount();
    }
}

