/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.bds;

import ch.systemsx.cisd.bds.Constants;
import ch.systemsx.cisd.bds.IStorable;
import ch.systemsx.cisd.bds.Utilities;
import ch.systemsx.cisd.bds.storage.IDirectory;
import java.util.Date;

public final class ExperimentRegistrationTimestamp
implements IStorable {
    static final String FILE_NAME = "experiment_registration_timestamp";
    private final Date date;

    static final ExperimentRegistrationTimestamp loadFrom(IDirectory directory) {
        return new ExperimentRegistrationTimestamp(Utilities.getDateOrNull(directory, FILE_NAME));
    }

    public ExperimentRegistrationTimestamp(Date date) {
        this.date = date;
    }

    public final Date getDate() {
        return this.date;
    }

    public final void saveTo(IDirectory directory) {
        directory.addKeyValuePair(FILE_NAME, Constants.DATE_FORMAT.format(this.date));
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ExperimentRegistrationTimestamp)) {
            return false;
        }
        return ((ExperimentRegistrationTimestamp)obj).getDate().getTime() == this.date.getTime();
    }

    public final int hashCode() {
        return (int)this.date.getTime();
    }

    public final String toString() {
        return Constants.DATE_FORMAT.format(this.date);
    }
}

