/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.bds;

import ch.systemsx.cisd.bds.Constants;
import ch.systemsx.cisd.bds.StringUtils;
import ch.systemsx.cisd.bds.exception.DataStructureException;
import ch.systemsx.cisd.bds.storage.IDirectory;
import ch.systemsx.cisd.bds.storage.IFile;
import ch.systemsx.cisd.bds.storage.INode;
import ch.systemsx.cisd.bds.storage.INodeFilter;
import ch.systemsx.cisd.bds.storage.NodeFilters;
import java.text.ParseException;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utilities {
    public static IDirectory getOrCreateSubDirectory(IDirectory directory, String name) {
        INode node = directory.tryGetNode(name);
        if (node == null) {
            return directory.makeDirectory(name);
        }
        if (node instanceof IDirectory) {
            return (IDirectory)node;
        }
        throw new DataStructureException("There is already a node named '" + name + "' but which isn't a directory (" + node + ").");
    }

    public static final IDirectory getSubDirectory(IDirectory directory, String name) throws DataStructureException {
        INode node = directory.tryGetNode(name);
        if (node == null) {
            throw new DataStructureException(String.format("No directory named '%s' found in directory '%s'.", name, directory));
        }
        if (!(node instanceof IDirectory)) {
            throw new DataStructureException("Is not a directory: " + node);
        }
        return (IDirectory)node;
    }

    public static String getTrimmedString(IDirectory directory, String name) {
        return Utilities.getString(directory, name).trim();
    }

    public static String getString(IDirectory directory, String name) {
        INode node = Utilities.tryGetFileNode(directory, name);
        IFile file = (IFile)node;
        return file.getStringContent();
    }

    public static List<String> getStringList(IDirectory directory, String name) {
        INode node = Utilities.tryGetFileNode(directory, name);
        IFile file = (IFile)node;
        return file.getStringContentList();
    }

    private static final INode tryGetFileNode(IDirectory directory, String name) {
        assert (directory != null) : String.format("Given directory can not be null.", new Object[0]);
        assert (name != null) : String.format("Given name can not be null.", new Object[0]);
        INode node = directory.tryGetNode(name);
        if (node == null) {
            throw new DataStructureException("File '" + name + "' missing in '" + directory + "'.");
        }
        if (!(node instanceof IFile)) {
            throw new DataStructureException(node + " is not a file.");
        }
        return node;
    }

    private Utilities() {
    }

    public static boolean getBoolean(IDirectory directory, String name) throws DataStructureException {
        String value = Utilities.getTrimmedString(directory, name);
        try {
            return Boolean.valueOf(value).toBoolean();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new DataStructureException("Value of '" + name + "' version file is not a boolean (TRUE or FALSE): " + value);
        }
    }

    public static final int getNumber(IDirectory directory, String name) throws DataStructureException {
        String value = Utilities.getTrimmedString(directory, name);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            throw new DataStructureException("Value of '" + name + "' version file is not a number: " + value);
        }
    }

    public static final Date getDateOrNull(IDirectory directory, String name) throws DataStructureException {
        String value = Utilities.getTrimmedString(directory, name);
        if (StringUtils.isEmpty(value)) {
            return null;
        }
        try {
            return Constants.DATE_FORMAT.parse(value);
        }
        catch (ParseException parseException) {
            throw new DataStructureException("Value of '" + name + "' version file is not a date: " + value);
        }
    }

    public static final List<String> listNodes(IDirectory diretory, INodeFilter nodeFilterOrNull) {
        assert (diretory != null) : "Given node can not be null.";
        INodeFilter nodeFilter = nodeFilterOrNull == null ? NodeFilters.TRUE_NODE_FILTER : nodeFilterOrNull;
        LinkedList<String> nodes = new LinkedList<String>();
        Utilities.innerListNodes(nodes, diretory, nodeFilter, "");
        return nodes;
    }

    private static final void innerListNodes(List<String> nodes, IDirectory directory, INodeFilter nodeFilter, String prepend) {
        assert (prepend != null) : "Prepend is never null.";
        for (INode child : directory) {
            if (child instanceof IFile && nodeFilter.accept(child)) {
                nodes.add(String.valueOf(prepend) + child.getName());
                continue;
            }
            if (!(child instanceof IDirectory)) continue;
            Utilities.innerListNodes(nodes, (IDirectory)child, nodeFilter, String.valueOf(prepend) + child.getName() + '/');
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Boolean {
        TRUE,
        FALSE;


        final boolean toBoolean() {
            return this == TRUE;
        }
    }
}

