/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.bds.handler;

import ch.systemsx.cisd.bds.IDataStructureHandler;
import ch.systemsx.cisd.bds.Utilities;
import ch.systemsx.cisd.bds.exception.DataStructureException;
import ch.systemsx.cisd.bds.handler.IChecksumCalculator;
import ch.systemsx.cisd.bds.handler.MD5ChecksumCalculator;
import ch.systemsx.cisd.bds.handler.NodeComparator;
import ch.systemsx.cisd.bds.storage.IDirectory;
import ch.systemsx.cisd.bds.storage.IFile;
import ch.systemsx.cisd.bds.storage.INode;
import ch.systemsx.cisd.common.collections.CollectionIO;
import ch.systemsx.cisd.common.collections.IFromStringConverter;
import ch.systemsx.cisd.common.collections.IToStringConverter;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ChecksumHandler
implements IDataStructureHandler {
    private static final ChecksumConverter CHECKSUM_CONVERTER = new ChecksumConverter();
    public static final String CHECKSUM_DIRECTORY = "md5sum";
    private final IChecksumCalculator checksumCalculator;
    private final IDirectory checksumDirectory;
    private final IDirectory originalDataDirectory;

    public ChecksumHandler(IDirectory checksumDirectory, IDirectory originalDataDirectory) {
        this.checksumDirectory = checksumDirectory;
        this.originalDataDirectory = originalDataDirectory;
        this.checksumCalculator = new MD5ChecksumCalculator();
    }

    private final List<Checksum> loadChecksumsForAllFilesIn(IDirectory directory) {
        assert (directory != null) : "Unspecified directory";
        ArrayList<Checksum> checksums = new ArrayList<Checksum>();
        this.addChecksums(checksums, null, directory);
        return checksums;
    }

    private void addChecksums(List<Checksum> checksums, String nodePath, IDirectory directory) {
        ArrayList<INode> children = new ArrayList<INode>();
        for (INode child : directory) {
            children.add(child);
        }
        Collections.sort(children, NodeComparator.BY_NAME_IGNORE_CASE);
        for (INode child : children) {
            this.addChecksum(checksums, nodePath, child);
        }
    }

    private final void addChecksum(List<Checksum> checksums, String path, INode node) {
        block8: {
            String nodePath = String.valueOf(path == null ? "" : String.valueOf(path) + '/') + node.getName();
            if (node instanceof IFile) {
                IFile file = (IFile)node;
                InputStream inputStream = file.getInputStream();
                try {
                    try {
                        Checksum checksum = new Checksum(this.checksumCalculator.calculateChecksum(inputStream), nodePath);
                        assert (!checksums.contains(checksum)) : String.format("Checksum '%s' is not unique.", checksum);
                        checksums.add(checksum);
                        break block8;
                    }
                    catch (IOException iOException) {
                        throw new EnvironmentFailureException("Couldn't calculate checksum for file '" + nodePath + "'");
                    }
                }
                finally {
                    IOUtils.closeQuietly((InputStream)inputStream);
                }
            }
            if (node instanceof IDirectory) {
                this.addChecksums(checksums, nodePath, (IDirectory)node);
            }
        }
    }

    @Override
    public final void assertValid() throws DataStructureException {
        List<String> expected = Utilities.getStringList(this.checksumDirectory, "original");
        List<Checksum> actual = this.loadChecksumsForAllFilesIn(this.originalDataDirectory);
        for (String value : expected) {
            Checksum checkum = CHECKSUM_CONVERTER.fromString(value);
            if (actual.remove(checkum)) continue;
            throw new DataStructureException(String.format("Given checksum '%s' not found in directory '%s'", checkum, this.originalDataDirectory));
        }
        if (actual.size() > 0) {
            throw new DataStructureException(String.format("Following checksums '%s' are not present in the checksum file '%s'.", actual, "original"));
        }
    }

    @Override
    public final void performClosing() {
        StringWriter writer = new StringWriter();
        List<Checksum> checksums = this.loadChecksumsForAllFilesIn(this.originalDataDirectory);
        CollectionIO.writeIterable(writer, checksums, CHECKSUM_CONVERTER);
        this.checksumDirectory.addKeyValuePair("original", writer.toString());
    }

    @Override
    public final void performOpening() {
    }

    private static final class Checksum {
        private final String checksum;
        private final String path;

        Checksum(String checksum, String path) {
            assert (checksum != null) : "Given checksum can not be null.";
            assert (path != null) : "Given path can not be null.";
            this.checksum = checksum;
            this.path = path;
        }

        public final boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Checksum)) {
                return false;
            }
            Checksum that = (Checksum)obj;
            return that.path.equals(this.path);
        }

        public final int hashCode() {
            int hashCode = 17;
            hashCode = hashCode * 37 + this.path.hashCode();
            return hashCode;
        }

        public final String toString() {
            return this.path;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ChecksumConverter
    implements IToStringConverter<Checksum>,
    IFromStringConverter<Checksum> {
        private static final String SEPARATOR = "  ";

        ChecksumConverter() {
        }

        @Override
        public final String toString(Checksum checksum) {
            return String.valueOf(checksum.checksum) + SEPARATOR + checksum.path;
        }

        @Override
        public final Checksum fromString(String value) {
            int index = value.indexOf(SEPARATOR);
            String checksum = value.substring(0, index);
            String path = value.substring(index + SEPARATOR.length());
            return new Checksum(checksum, path);
        }
    }
}

