/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.bds.handler;

import ch.systemsx.cisd.bds.IDataStructureHandler;
import ch.systemsx.cisd.bds.Reference;
import ch.systemsx.cisd.bds.ReferenceType;
import ch.systemsx.cisd.bds.Utilities;
import ch.systemsx.cisd.bds.exception.DataStructureException;
import ch.systemsx.cisd.bds.storage.IDirectory;
import ch.systemsx.cisd.common.collections.CollectionIO;
import ch.systemsx.cisd.common.collections.IToStringConverter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MappingFileHandler
implements IDataStructureHandler {
    private final Set<Reference> references = new HashSet<Reference>();
    private final IDirectory mappingDirectory;
    private final IDirectory pathRoot;
    private final IDirectory originalPathRoot;
    public static final String MAPPING_FILE = "standard_original_mapping";

    public MappingFileHandler(IDirectory mappingDirectory, IDirectory pathRoot, IDirectory originalPathRoot) {
        assert (mappingDirectory != null) : "Given mapping directory can not be null.";
        assert (pathRoot != null) : "Given path root can not be null.";
        assert (originalPathRoot != null) : "Given original path root can not be null.";
        this.mappingDirectory = mappingDirectory;
        this.pathRoot = pathRoot;
        this.originalPathRoot = originalPathRoot;
    }

    public final Set<Reference> getReferences() {
        return Collections.unmodifiableSet(this.references);
    }

    public final void addReference(Reference reference) throws DataStructureException {
        assert (reference != null) : "Unspecified reference.";
        if (this.references.contains(reference)) {
            throw new DataStructureException("There is already a reference for file '" + reference + "'.");
        }
        this.references.add(reference);
    }

    private final void loadStandardOriginalMapping() {
        List<String> mappingLines = Utilities.getStringList(this.mappingDirectory, MAPPING_FILE);
        this.references.clear();
        int i = 0;
        while (i < mappingLines.size()) {
            String referenceDefinition = mappingLines.get(i);
            int i1 = referenceDefinition.indexOf(9);
            if (i1 < 0) {
                throw new DataStructureException("Error in standard-original mapping line " + (i + 1) + ": missing first tab character: " + referenceDefinition);
            }
            String path = referenceDefinition.substring(0, i1);
            int i2 = referenceDefinition.indexOf(9, i1 + 1);
            if (i2 < 0) {
                throw new DataStructureException("Error in standard-original mapping line " + (i + 1) + ": missing second tab character: " + referenceDefinition);
            }
            ReferenceType type = ReferenceType.resolveByShortName(referenceDefinition.substring(i1 + 1, i2));
            this.references.add(new Reference(path, referenceDefinition.substring(i2 + 1), type));
            ++i;
        }
    }

    private final String createMappingFile() {
        StringWriter writer = new StringWriter();
        CollectionIO.writeIterable(writer, this.references, new ReferenceToStringConverter());
        return writer.toString();
    }

    @Override
    public final void assertValid() throws DataStructureException {
        for (Reference reference : this.references) {
            String path = reference.getPath();
            if (this.pathRoot.tryGetNode(path) == null) {
                throw new DataStructureException(String.format("Node '%s' not found in directory '%s'", path, this.pathRoot));
            }
            String originalPath = reference.getOriginalPath();
            if (this.originalPathRoot.tryGetNode(originalPath) != null) continue;
            throw new DataStructureException(String.format("Node '%s' not found in directory '%s'", originalPath, this.originalPathRoot));
        }
    }

    @Override
    public final void performClosing() {
        this.mappingDirectory.addKeyValuePair(MAPPING_FILE, this.createMappingFile());
    }

    @Override
    public final void performOpening() {
        this.loadStandardOriginalMapping();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ReferenceToStringConverter
    implements IToStringConverter<Reference> {
        private static final String ITEM_SEPARATOR = "\t";
        private final StringBuilder builder = new StringBuilder();

        private ReferenceToStringConverter() {
        }

        @Override
        public final String toString(Reference reference) {
            this.builder.setLength(0);
            this.builder.append(reference.getPath()).append(ITEM_SEPARATOR);
            this.builder.append(reference.getReferenceType().getShortName()).append(ITEM_SEPARATOR);
            this.builder.append(reference.getOriginalPath());
            return this.builder.toString();
        }
    }
}

