/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.bds.storage.filesystem;

import ch.systemsx.cisd.bds.exception.StorageException;
import ch.systemsx.cisd.bds.storage.IDirectory;
import ch.systemsx.cisd.bds.storage.INode;
import ch.systemsx.cisd.bds.storage.filesystem.Directory;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import java.io.File;

abstract class AbstractNode
implements INode {
    protected final File nodeFile;

    protected static final File moveFileToDirectory(File source, File directory, String nameOrNull) throws EnvironmentFailureException {
        boolean successful;
        assert (source != null);
        assert (directory != null && directory.isDirectory());
        String newName = nameOrNull == null ? source.getName() : nameOrNull;
        File destination = new File(directory, newName);
        if (!destination.exists() && !(successful = source.renameTo(destination))) {
            throw EnvironmentFailureException.fromTemplate("Couldn't not move file '%s' to directory '%s'.", source.getAbsolutePath(), directory.getAbsolutePath());
        }
        return destination;
    }

    AbstractNode(File file) {
        AbstractNode.checkFile(file);
        this.nodeFile = file;
    }

    static void checkFile(File file) {
        if (file == null) {
            throw new StorageException("Unspecified file.");
        }
        if (!file.exists()) {
            throw new StorageException(String.format("Non existing file '%s'.", file.getAbsolutePath()));
        }
    }

    public final String getName() {
        return this.nodeFile.getName();
    }

    public final IDirectory tryToGetParent() {
        File dir = this.nodeFile.getParentFile();
        return dir == null ? null : new Directory(dir);
    }

    public final void moveTo(File directory) {
        AbstractNode.moveFileToDirectory(this.nodeFile, directory, null);
    }

    public boolean isValid() {
        return this.nodeFile.exists();
    }

    public final String toString() {
        return this.nodeFile.getAbsolutePath();
    }
}

