/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.bds.storage.filesystem;

import ch.systemsx.cisd.bds.storage.IFile;
import ch.systemsx.cisd.bds.storage.filesystem.AbstractNode;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.utilities.FileUtilities;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class File
extends AbstractNode
implements IFile {
    File(java.io.File file) {
        super(file);
        assert (file.isFile()) : "Not a file " + file.getAbsolutePath();
    }

    @Override
    public final byte[] getBinaryContent() {
        InputStream inputStream = this.getInputStream();
        try {
            byte[] byArray = IOUtils.toByteArray((InputStream)inputStream);
            return byArray;
        }
        catch (IOException ex) {
            throw new EnvironmentFailureException("Couldn't get data from file " + this.nodeFile.getAbsolutePath(), ex);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    @Override
    public final InputStream getInputStream() {
        try {
            return new FileInputStream(this.nodeFile);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new EnvironmentFailureException("Couldn't open input stream for file " + this.nodeFile.getAbsolutePath());
        }
    }

    @Override
    public final String getStringContent() {
        return FileUtilities.loadToString(this.nodeFile);
    }

    @Override
    public final List<String> getStringContentList() {
        return FileUtilities.loadToStringList(this.nodeFile);
    }

    @Override
    public final void extractTo(java.io.File directory) throws EnvironmentFailureException {
        assert (directory != null && directory.isDirectory());
        try {
            FileUtils.copyFileToDirectory((java.io.File)this.nodeFile, (java.io.File)directory);
        }
        catch (IOException ex) {
            throw EnvironmentFailureException.fromTemplate(ex, "Couldn't not copy file '%s' to directory '%s'.", this.nodeFile.getAbsolutePath(), directory.getAbsolutePath());
        }
    }
}

