/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.bds.storage.filesystem;

import ch.systemsx.cisd.bds.storage.IDirectory;
import ch.systemsx.cisd.bds.storage.IFile;
import ch.systemsx.cisd.bds.storage.ILink;
import ch.systemsx.cisd.bds.storage.INode;
import java.io.File;

final class Link
implements ILink {
    private final String name;
    private final INode reference;
    private IDirectory parent;

    Link(String name, INode reference) {
        assert (name != null) : "A name must be specified.";
        assert (reference != null) : "Reference can not be null.";
        assert (reference instanceof IFile) : "Given reference must be of type IFile: " + reference.getClass().getName();
        assert (reference.isValid()) : "Given reference must be valid: " + reference;
        this.name = name;
        this.reference = reference;
    }

    final void setParent(IDirectory parentOrNull) {
        this.parent = parentOrNull;
    }

    public final String getName() {
        return this.name;
    }

    public final IDirectory tryToGetParent() {
        return this.parent;
    }

    public final INode getReference() {
        return this.reference;
    }

    public final void extractTo(File directory) {
        this.reference.extractTo(directory);
    }

    public final void moveTo(File directory) {
        this.reference.moveTo(directory);
    }

    public final boolean isValid() {
        if (!this.reference.isValid()) {
            return false;
        }
        if (this.parent != null) {
            INode node = this.parent.tryGetNode(this.name);
            return node != null && node.isValid();
        }
        return true;
    }
}

