/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.collections;

import ch.systemsx.cisd.common.collections.IKeyExtractor;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableMap<K, E>
implements Iterable<E> {
    private final Map<K, E> map = new LinkedHashMap<K, E>();
    private final IKeyExtractor<K, E> extractor;
    private final UniqueKeyViolationStrategy uniqueKeyViolationStrategy;

    public TableMap(IKeyExtractor<K, E> extractor) {
        this(null, extractor, UniqueKeyViolationStrategy.ERROR);
    }

    public TableMap(IKeyExtractor<K, E> extractor, UniqueKeyViolationStrategy uniqueKeyViolationStrategy) {
        this(null, extractor, uniqueKeyViolationStrategy);
    }

    public TableMap(Iterable<E> rows, IKeyExtractor<K, E> extractor) {
        this(rows, extractor, UniqueKeyViolationStrategy.ERROR);
    }

    public TableMap(Iterable<E> rowsOrNull, IKeyExtractor<K, E> extractor, UniqueKeyViolationStrategy uniqueKeyViolationStrategy) {
        assert (extractor != null) : "Unspecified key extractor.";
        assert (uniqueKeyViolationStrategy != null) : "Unspecified unique key violation strategy.";
        this.extractor = extractor;
        this.uniqueKeyViolationStrategy = uniqueKeyViolationStrategy;
        if (rowsOrNull != null) {
            for (E row : rowsOrNull) {
                this.add(row);
            }
        }
    }

    public final void add(E row) throws UniqueKeyViolationException {
        K key = this.extractor.getKey(row);
        if (this.uniqueKeyViolationStrategy == UniqueKeyViolationStrategy.KEEP_LAST || this.map.get(key) == null) {
            this.map.put(key, row);
        } else if (this.uniqueKeyViolationStrategy == UniqueKeyViolationStrategy.ERROR) {
            throw new UniqueKeyViolationException("Key '" + key.toString() + "' already in the map.");
        }
    }

    public final E tryGet(K key) {
        return this.map.get(key);
    }

    public final Collection<E> values() {
        return Collections.unmodifiableCollection(this.map.values());
    }

    public final Set<K> keySet() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    @Override
    public final Iterator<E> iterator() {
        return new Iterator<E>(){
            private Iterator<Map.Entry<K, E>> iterator;
            {
                this.iterator = TableMap.this.map.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public E next() {
                return this.iterator.next().getValue();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Can not remove an element.");
            }
        };
    }

    public static class UniqueKeyViolationException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        UniqueKeyViolationException(String msg) {
            super(msg);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UniqueKeyViolationStrategy {
        KEEP_FIRST,
        KEEP_LAST,
        ERROR;

    }
}

