/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.concurrent;

import ch.systemsx.cisd.common.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.logging.ISimpleLogger;
import ch.systemsx.cisd.common.logging.LogLevel;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConcurrencyUtilities {
    public static ExecutorService newNamedPool(final String name, int corePoolSize, int maximumPoolSize) {
        return new ThreadPoolExecutor(corePoolSize, maximumPoolSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){
            private int executorThreadCount = 1;

            public Thread newThread(Runnable r) {
                return new Thread(r, String.valueOf(name) + " " + this.executorThreadCount);
            }
        });
    }

    public static <T> T tryGetResult(Future<T> future, long timeoutMillis) {
        return ConcurrencyUtilities.tryGetResult(future, timeoutMillis, null, null);
    }

    public static <T> T tryGetResult(Future<T> future, long timeoutMillis, ISimpleLogger loggerOrNull, String operationNameOrNull) {
        String operationName = operationNameOrNull == null ? "UNKNOWN OPERATION" : operationNameOrNull;
        try {
            return future.get(timeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException timeoutException) {
            future.cancel(true);
            if (loggerOrNull != null) {
                loggerOrNull.log(LogLevel.DEBUG, String.format("%s took longer than %f s, cancelled.", operationName, Float.valueOf((float)timeoutMillis / 1000.0f)));
            }
            return null;
        }
        catch (InterruptedException interruptedException) {
            future.cancel(true);
            if (loggerOrNull != null) {
                loggerOrNull.log(LogLevel.DEBUG, String.format("%s got interrupted.", operationName));
            }
            return null;
        }
        catch (ExecutionException ex) {
            Throwable cause = ex.getCause();
            if (loggerOrNull != null) {
                String message = cause == null || cause.getMessage() == null ? "<no message>" : cause.getMessage();
                String className = cause == null ? "<unknown class>" : cause.getClass().getSimpleName();
                loggerOrNull.log(LogLevel.ERROR, String.format("%s has caused an exception: %s [%s]", operationName, message, className));
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)cause);
        }
    }
}

