/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.process;

import ch.systemsx.cisd.common.process.ProcessExecutionHelper;
import java.io.File;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProcessResult {
    private final Process processOrNull;
    private final boolean hasBlocked;
    private final List<String> commandLine;
    private final String commandName;
    private final Logger operationLog;
    private final Logger machineLog;
    private List<String> outputLines;

    public static ProcessResult create(Process process, List<String> commandLine, Logger operationLog, Logger machineLog) {
        return new ProcessResult(process, false, commandLine, operationLog, machineLog);
    }

    public static ProcessResult createNotStarted(List<String> commandLine, Logger operationLog, Logger machineLog) {
        return new ProcessResult(null, false, commandLine, operationLog, machineLog);
    }

    public static ProcessResult createWaitingInterrupted(Process process, List<String> commandLine, Logger operationLog, Logger machineLog) {
        return new ProcessResult(process, true, commandLine, operationLog, machineLog);
    }

    private ProcessResult(Process processOrNull, boolean hasBlocked, List<String> commandLine, Logger operationLog, Logger machineLog) {
        this.commandLine = commandLine;
        this.commandName = new File(commandLine.get(0)).getName();
        this.processOrNull = processOrNull;
        this.hasBlocked = hasBlocked;
        this.operationLog = operationLog;
        this.machineLog = machineLog;
        this.outputLines = null;
    }

    public void destroyProcess() {
        if (this.processOrNull != null) {
            this.processOrNull.destroy();
        }
    }

    public List<String> getCommandLine() {
        return this.commandLine;
    }

    public String getCommandName() {
        return this.commandName;
    }

    public List<String> getProcessOutput() {
        if (this.outputLines == null) {
            this.outputLines = ProcessExecutionHelper.readProcessOutputLines(this.processOrNull, this.machineLog);
        }
        return this.outputLines;
    }

    public int exitValue() {
        if (!this.hasBlocked && this.processOrNull != null) {
            return this.processOrNull.exitValue();
        }
        return -1;
    }

    public boolean isOK() {
        return this.exitValue() == 0;
    }

    public boolean isRun() {
        return this.processOrNull != null;
    }

    public boolean hasBlocked() {
        return this.hasBlocked;
    }

    public boolean isTerminated() {
        return ProcessExecutionHelper.isProcessTerminated(this.exitValue());
    }

    public void log() {
        if (!this.isOK()) {
            this.logProcessExitValue(Level.WARN);
            this.logProcessOutput(Level.WARN);
        } else if (this.operationLog.isDebugEnabled()) {
            this.logProcessExitValue(Level.DEBUG);
            this.logProcessOutput(Level.DEBUG);
        }
    }

    private void logProcessExitValue(Level logLevel) {
        if (!this.isRun()) {
            this.operationLog.log(logLevel, String.format("[%s] process could not be run.", this.commandName));
        } else if (this.isTerminated()) {
            this.operationLog.log(logLevel, String.format("[%s] process was destroyed.", this.commandName));
        } else if (this.hasBlocked()) {
            this.operationLog.log(logLevel, String.format("[%s] process has blocked and could not be destroyed.", this.commandName));
        } else {
            this.operationLog.log(logLevel, String.format("[%s] process returned with exit value %d.", this.commandName, this.exitValue()));
        }
    }

    private void logProcessOutput(Level logLevel) {
        assert (logLevel != null);
        List<String> processOutputLines = this.getProcessOutput();
        if (processOutputLines.size() == 0) {
            return;
        }
        this.machineLog.log(logLevel, String.format("[%s] output:", this.commandName));
        for (String ln : processOutputLines) {
            if (ln.trim().length() <= 0) continue;
            this.machineLog.log(logLevel, String.format("\"%s\"", ln));
        }
    }
}

