/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.utilities;

import ch.systemsx.cisd.common.exceptions.CheckedExceptionTunnel;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassUtils {
    private ClassUtils() {
    }

    public static final Collection<Class<?>> gatherAllCastableClassesAndInterfacesFor(Object object) {
        assert (object != null) : "Unspecified object";
        LinkedHashSet classes = new LinkedHashSet();
        classes.add(object.getClass());
        classes.addAll(ClassUtils.getAllSuperclasses(object));
        classes.addAll(ClassUtils.getAllInterfaces(object));
        return classes;
    }

    private static final List<Class<?>> getAllInterfaces(Object object) {
        assert (object != null) : "Unspecified object";
        return org.apache.commons.lang.ClassUtils.getAllInterfaces(object.getClass());
    }

    private static final List<Class<?>> getAllSuperclasses(Object object) {
        assert (object != null) : "Unspecified object";
        return org.apache.commons.lang.ClassUtils.getAllSuperclasses(object.getClass());
    }

    public static final Method getCurrentMethod() {
        return ClassUtils.getMethodOnStack(2);
    }

    public static final Method getMethodOnStack(int level) {
        StackTraceElement[] elements = new Throwable().getStackTrace();
        if (elements.length <= level) {
            return null;
        }
        StackTraceElement element = elements[level];
        String methodName = element.getMethodName();
        try {
            Method[] methods;
            Method[] methodArray = methods = Class.forName(element.getClassName()).getMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (method.getName().equals(methodName)) {
                    return method;
                }
                ++n2;
            }
        }
        catch (Exception ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
        return null;
    }

    public static <T> T create(Class<T> superClazz, String className, Object ... argumentsOrNull) {
        assert (superClazz != null) : "Missing super class";
        assert (className != null) : "Missing class name";
        try {
            Class<?> clazz = Class.forName(className);
            assert (!clazz.isInterface()) : "Interface '" + clazz.getName() + "' can not be instanciated as it is an interface.";
            assert (superClazz.isAssignableFrom(clazz)) : "Class '" + clazz.getName() + "' does not implements/extends '" + superClazz.getName() + "'.";
            if (argumentsOrNull == null) {
                return ClassUtils.cast(clazz.newInstance());
            }
            Class<?>[] classes = ClassUtils.getClasses(argumentsOrNull);
            Constructor<T> constructor = ClassUtils.getConstructor(clazz, classes);
            if (constructor == null) {
                if (classes.length == 0) {
                    throw new IllegalArgumentException("No default constructor found for " + clazz);
                }
                throw new IllegalArgumentException("No constructor found for " + clazz + " with arguments of the following types: " + Arrays.asList(classes));
            }
            return constructor.newInstance(argumentsOrNull);
        }
        catch (ClassNotFoundException e) {
            throw CheckedExceptionTunnel.wrapIfNecessary(e);
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof Error) {
                Error error = (Error)cause;
                throw error;
            }
            if (cause instanceof Exception) {
                throw CheckedExceptionTunnel.wrapIfNecessary((Exception)cause);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        throw new IllegalArgumentException(String.format("Cannot instantiate class '%s' with given arguments '%s'.", className, Arrays.asList(argumentsOrNull)));
    }

    private static <T> T cast(Object newInstance) {
        return (T)newInstance;
    }

    private static final Class<?>[] getClasses(Object ... initargs) {
        Class[] classes = new Class[initargs.length];
        int i = 0;
        Object[] objectArray = initargs;
        int n = initargs.length;
        int n2 = 0;
        while (n2 < n) {
            Object initarg = objectArray[n2];
            classes[i++] = initarg.getClass();
            ++n2;
        }
        return classes;
    }

    private static final <T> Constructor<T> getConstructor(Class<?> clazz, Class<?>[] classes) throws NoSuchMethodException {
        Constructor<?>[] constructors = clazz.getConstructors();
        Constructor<?> returned = null;
        Constructor<?>[] constructorArray = constructors;
        int n = constructors.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor<?> constructor = constructorArray[n2];
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            int len = parameterTypes.length;
            if (len == classes.length) {
                boolean match = true;
                int i = 0;
                while (i < len) {
                    Class<?> parameterType = parameterTypes[i];
                    Class<?> c = classes[i];
                    match &= parameterType.equals(c) || parameterType.isAssignableFrom(c);
                    ++i;
                }
                if (match) {
                    returned = constructor;
                }
            }
            ++n2;
        }
        return ClassUtils.toGenericType(returned);
    }

    private static <T> Constructor<T> toGenericType(Constructor<?> returned) {
        return returned;
    }

    public static final <T> T createInstance(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
        catch (IllegalAccessException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    public static final void invokeMethod(Method method, Object obj, Object ... args) {
        try {
            method.invoke(obj, args);
        }
        catch (IllegalAccessException ex) {
            throw new CheckedExceptionTunnel(ex);
        }
        catch (InvocationTargetException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex.getCause());
        }
    }

    public static final boolean setFieldValue(Object object, String fieldName, Object newValue) {
        assert (object != null) : "Unspecified object.";
        Class<?> clazz = object.getClass();
        try {
            Field field = ClassUtils.tryGetDeclaredField(clazz, fieldName);
            if (field != null) {
                field.setAccessible(true);
                field.set(object, newValue);
                return true;
            }
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {}
        return false;
    }

    private static final Field tryGetDeclaredField(Class<?> c, String fieldName) {
        assert (c != null) : "Unspecified class.";
        assert (StringUtils.isNotBlank((String)fieldName)) : "Blank field name.";
        Field field = null;
        Class<?> clazz = c;
        do {
            try {
                field = clazz.getDeclaredField(fieldName);
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchFieldException noSuchFieldException) {}
            clazz = clazz.getSuperclass();
        } while (field == null && clazz != null);
        return field;
    }
}

