/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.mail.IMailClient;
import ch.systemsx.cisd.etlserver.DataSetInformation;
import ch.systemsx.cisd.etlserver.DataStoreStrategyKey;
import ch.systemsx.cisd.etlserver.IDataStoreStrategy;
import ch.systemsx.cisd.etlserver.IDataStrategyStore;
import ch.systemsx.cisd.etlserver.IEncapsulatedLimsService;
import ch.systemsx.cisd.etlserver.IdentifiedDataStrategy;
import ch.systemsx.cisd.etlserver.NamedDataStrategy;
import ch.systemsx.cisd.lims.base.BaseExperiment;
import ch.systemsx.cisd.lims.base.ExperimentIdentifier;
import ch.systemsx.cisd.lims.base.Person;
import ch.systemsx.cisd.lims.base.properties.SimpleEntityProperty;
import java.io.File;
import java.util.EnumMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DataStrategyStore
implements IDataStrategyStore {
    static final String SUBJECT_FORMAT = "ATTENTION: experiment '%s'";
    private static final Logger notificationLog = LogFactory.getLogger(LogCategory.NOTIFY, DataStrategyStore.class);
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, DataStrategyStore.class);
    private final IEncapsulatedLimsService limsService;
    private final IMailClient mailClient;
    private final Map<DataStoreStrategyKey, IDataStoreStrategy> dataStoreStrategies;

    DataStrategyStore(IEncapsulatedLimsService limsService, IMailClient mailClient) {
        this.mailClient = mailClient;
        this.dataStoreStrategies = DataStrategyStore.createDataStoreStrategies();
        this.limsService = limsService;
    }

    private static final void putDataStoreStrategy(Map<DataStoreStrategyKey, IDataStoreStrategy> map, IDataStoreStrategy dataStoreStrategy) {
        map.put(dataStoreStrategy.getKey(), dataStoreStrategy);
    }

    private static final Map<DataStoreStrategyKey, IDataStoreStrategy> createDataStoreStrategies() {
        EnumMap<DataStoreStrategyKey, IDataStoreStrategy> map = new EnumMap<DataStoreStrategyKey, IDataStoreStrategy>(DataStoreStrategyKey.class);
        DataStrategyStore.putDataStoreStrategy(map, new IdentifiedDataStrategy());
        DataStrategyStore.putDataStoreStrategy(map, new NamedDataStrategy(DataStoreStrategyKey.UNIDENTIFIED));
        DataStrategyStore.putDataStoreStrategy(map, new NamedDataStrategy(DataStoreStrategyKey.INVALID));
        return map;
    }

    static final String createInvalidSampleCodeMessage(DataSetInformation dataSetInfo) {
        return "ETL server: Sample '" + dataSetInfo.getSampleCode() + "' is not valid for experiment '" + dataSetInfo.getExperimentIdentifier() + "' (it has maybe been invalidated?).";
    }

    private static String createNotificationMessage(DataSetInformation dataSetInfo, File incomingDataSetPathForLogging) {
        String sampleCode = dataSetInfo.getSampleCode();
        ExperimentIdentifier experimentIdentifier = dataSetInfo.getExperimentIdentifier();
        if (experimentIdentifier == null) {
            return String.format("Directory '%s', sample code '%s': unknown to openBIS", incomingDataSetPathForLogging, sampleCode);
        }
        return String.format("Directory '%s', experiment code '%s', sample code '%s': unknown to openBIS", incomingDataSetPathForLogging, experimentIdentifier, sampleCode);
    }

    private static final ExperimentIdentifier createExperimentIdentifier(BaseExperiment experiment) {
        ExperimentIdentifier experimentIdentifier = new ExperimentIdentifier();
        experimentIdentifier.setExperimentCode(experiment.getCode());
        experimentIdentifier.setProjectCode(experiment.getProject().getCode());
        experimentIdentifier.setGroupCode(experiment.getProject().getGroup().getCode());
        return experimentIdentifier;
    }

    @Override
    public final IDataStoreStrategy getDataStoreStrategy(DataSetInformation dataSetInfo, File incomingDataSetPath) {
        assert (incomingDataSetPath != null) : "Incoming data set path can not be null.";
        if (dataSetInfo == null) {
            return this.dataStoreStrategies.get((Object)DataStoreStrategyKey.UNIDENTIFIED);
        }
        BaseExperiment experiment = this.limsService.getBaseExperiment(dataSetInfo);
        String sampleCode = dataSetInfo.getSampleCode();
        if (experiment == null) {
            notificationLog.error(DataStrategyStore.createNotificationMessage(dataSetInfo, incomingDataSetPath));
            return this.dataStoreStrategies.get((Object)DataStoreStrategyKey.UNIDENTIFIED);
        }
        if (experiment.isInvalidated()) {
            notificationLog.error("Data set for sample '" + sampleCode + "' can not be registered because experiment '" + experiment.getCode() + "' has been invalidated.");
            return this.dataStoreStrategies.get((Object)DataStoreStrategyKey.UNIDENTIFIED);
        }
        ExperimentIdentifier experimentIdentifier = dataSetInfo.getExperimentIdentifier();
        if (experimentIdentifier == null) {
            experimentIdentifier = DataStrategyStore.createExperimentIdentifier(experiment);
            dataSetInfo.setExperimentIdentifier(experimentIdentifier);
        } else {
            String groupCode = experiment.getProject().getGroup().getCode();
            dataSetInfo.getExperimentIdentifier().setGroupCode(groupCode);
        }
        assert (experiment.getCode().equals(experimentIdentifier.getExperimentCode())) : "Experiment codes do not match.";
        assert (experiment.getProject().getCode().equals(experimentIdentifier.getProjectCode())) : "Project codes do not match.";
        SimpleEntityProperty[] properties = this.limsService.tryToGetPropertiesOfTopSampleRegisteredFor(sampleCode);
        if (properties == null) {
            Person registrator = experiment.getRegistrator();
            assert (registrator != null) : "Registrator must be known";
            String message = DataStrategyStore.createInvalidSampleCodeMessage(dataSetInfo);
            String recipientMail = registrator.getEmail();
            if (StringUtils.isNotBlank((String)recipientMail)) {
                this.sendEmail(message, experimentIdentifier, recipientMail);
            } else {
                notificationLog.error("The registrator '" + registrator + "' has a blank email, sending the following email failed:\n" + message);
            }
            operationLog.error(String.format("Incoming data set '%s' claims to belong to experiment '%s' and sample code '%s', but according to the openBIS server there is no such sample for this experiment (it has maybe been invalidated?). We thus consider it invalid.", incomingDataSetPath, experimentIdentifier, sampleCode));
            return this.dataStoreStrategies.get((Object)DataStoreStrategyKey.INVALID);
        }
        dataSetInfo.setSampleProperties(properties);
        if (operationLog.isInfoEnabled()) {
            operationLog.info("Identified that database knows experiment '" + experimentIdentifier + "' and sample '" + sampleCode + "'.");
        }
        return this.dataStoreStrategies.get((Object)DataStoreStrategyKey.IDENTIFIED);
    }

    private void sendEmail(String message, ExperimentIdentifier experimentIdentifier, String recipientMail) {
        String subject = String.format(SUBJECT_FORMAT, experimentIdentifier);
        try {
            this.mailClient.sendMessage(subject, message, recipientMail);
        }
        catch (EnvironmentFailureException ex) {
            operationLog.error(ex.getMessage());
        }
    }
}

