/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.mail.IMailClient;
import ch.systemsx.cisd.etlserver.AbstractStorageProcessor;
import ch.systemsx.cisd.etlserver.DataSetInformation;
import ch.systemsx.cisd.etlserver.DataSetMover;
import ch.systemsx.cisd.etlserver.IProcedureAndDataTypeExtractor;
import ch.systemsx.cisd.lims.base.BaseExperiment;
import ch.systemsx.cisd.lims.base.util.StorageFormat;
import java.io.File;
import java.util.Properties;

public class DefaultStorageProcessor
extends AbstractStorageProcessor {
    static final String NO_RENAME = "Couldn't rename '%s' to '%s'.";
    private DataSetMover dataSetMover;

    public DefaultStorageProcessor(Properties globalProperties) {
        super(globalProperties);
        this.dataSetMover = new DataSetMover(globalProperties);
    }

    private static final File createTargetFile(File incomingDataSetFile, File baseDirectory) {
        return new File(baseDirectory, incomingDataSetFile.getName());
    }

    public final File storeData(BaseExperiment experiment, DataSetInformation dataSetInformation, IProcedureAndDataTypeExtractor typeExtractor, IMailClient mailClient, File incomingDataSetDirectory, File rootDir) {
        DefaultStorageProcessor.checkParameters(incomingDataSetDirectory, rootDir);
        File targetFile = DefaultStorageProcessor.createTargetFile(incomingDataSetDirectory, rootDir);
        if (!this.dataSetMover.moveDataSetAndLog(incomingDataSetDirectory, targetFile)) {
            throw new EnvironmentFailureException(String.format(NO_RENAME, incomingDataSetDirectory, targetFile));
        }
        return targetFile;
    }

    public void storeDataSetCode(String dataSetCode) {
    }

    public final void unstoreData(File incomingDataSetDirectory, File storedDataDirectory) {
        DefaultStorageProcessor.checkParameters(incomingDataSetDirectory, storedDataDirectory);
        this.dataSetMover.moveDataSetAndLog(DefaultStorageProcessor.createTargetFile(incomingDataSetDirectory, storedDataDirectory), incomingDataSetDirectory);
    }

    public final StorageFormat getStorageFormat() {
        return StorageFormat.PROPRIETARY;
    }

    public final File tryGetProprietaryData(File storedDataDirectory) {
        return storedDataDirectory;
    }
}

